/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.client.gui.widget.button;

import com.dynious.refinedrelocation.client.gui.IGuiParent;
import com.dynious.refinedrelocation.client.gui.widget.button.GuiButtonCounter;
import com.dynious.refinedrelocation.grid.relocator.RelocatorModuleCrafting;
import com.dynious.refinedrelocation.helper.GuiHelper;
import com.dynious.refinedrelocation.lib.Strings;
import java.util.List;
import net.minecraft.util.StatCollector;

public class GuiButtonMaxCraftStack
extends GuiButtonCounter {
    protected RelocatorModuleCrafting tile;

    public GuiButtonMaxCraftStack(IGuiParent parent, int x, int y, RelocatorModuleCrafting tile) {
        super(parent, x, y, 24, 20, 0, 64, 1, 16);
        this.tile = tile;
        this.update();
        this.setAdventureModeRestriction(true);
    }

    @Override
    protected void onValueChangedByUser(double newValue) {
        if (this.tile == null) {
            return;
        }
        this.tile.setMaxCraftStack((int)newValue);
        GuiHelper.sendIntMessage(0, (int)newValue);
    }

    @Override
    public void getTooltip(List<String> tooltip, int mouseX, int mouseY) {
        super.getTooltip(tooltip, mouseX, mouseY);
        if (this.isInsideBounds(mouseX, mouseY)) {
            tooltip.add(StatCollector.func_74838_a((String)Strings.MAX_CRAFT_STACK));
        }
    }

    @Override
    public void update() {
        if (this.tile != null) {
            this.setValue(this.tile.getMaxCraftStack());
        }
        super.update();
    }
}

