/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.client.gui.widget.button;

import com.dynious.refinedrelocation.client.graphics.TextureRegion;
import com.dynious.refinedrelocation.client.gui.IGuiParent;
import com.dynious.refinedrelocation.client.gui.SharedAtlas;
import com.dynious.refinedrelocation.client.gui.widget.button.GuiButton;
import com.dynious.refinedrelocation.grid.relocator.RelocatorModuleExtraction;
import com.dynious.refinedrelocation.helper.GuiHelper;
import com.dynious.refinedrelocation.lib.Strings;
import java.util.List;
import net.minecraft.util.StatCollector;

public class GuiButtonPulseExtractionToggle
extends GuiButton {
    private final RelocatorModuleExtraction module;
    private final TextureRegion[] textureAlwaysActive = new TextureRegion[2];
    private final TextureRegion[] textureRedstoneLow = new TextureRegion[2];
    private final TextureRegion[] textureRedstoneHigh = new TextureRegion[2];
    private final TextureRegion[] textureRedstonePulse = new TextureRegion[2];

    public GuiButtonPulseExtractionToggle(IGuiParent parent, int x, int y, RelocatorModuleExtraction module) {
        super(parent, x, y, 24, 20, null, null);
        this.module = module;
        this.textureAlwaysActive[0] = SharedAtlas.findRegion("button_always_active");
        this.textureAlwaysActive[1] = SharedAtlas.findRegion("button_always_active_hover");
        this.textureRedstoneLow[0] = SharedAtlas.findRegion("button_redstone_low");
        this.textureRedstoneLow[1] = SharedAtlas.findRegion("button_redstone_low_hover");
        this.textureRedstoneHigh[0] = SharedAtlas.findRegion("button_redstone_high");
        this.textureRedstoneHigh[1] = SharedAtlas.findRegion("button_redstone_high_hover");
        this.textureRedstonePulse[0] = SharedAtlas.findRegion("button_redstone_pulse");
        this.textureRedstonePulse[1] = SharedAtlas.findRegion("button_redstone_pulse_hover");
        this.setButtonTextures(this.textureAlwaysActive);
        this.update();
        this.setAdventureModeRestriction(true);
    }

    @Override
    public void update() {
        if (this.module != null) {
            this.setNewState(this.module.redstoneControlState, false);
        }
        super.update();
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int type, boolean isShiftKeyDown) {
        if (this.isInsideBounds(mouseX, mouseY)) {
            if (type == 0) {
                this.setNewState(this.getNextControlState(), true);
            } else if (type == 1) {
                this.setNewState(this.getPreviousControlState(), true);
            }
        }
        super.mouseClicked(mouseX, mouseY, type, isShiftKeyDown);
    }

    private int getNextControlState() {
        return this.module.redstoneControlState == 3 ? 0 : this.module.redstoneControlState + 1;
    }

    private int getPreviousControlState() {
        return this.module.redstoneControlState - 1 >= 0 ? this.module.redstoneControlState - 1 : 3;
    }

    protected void setNewState(int newState, boolean sendUpdate) {
        if (this.module == null) {
            return;
        }
        this.module.redstoneControlState = newState;
        if (sendUpdate) {
            GuiHelper.sendIntMessage(1, newState);
        }
        switch (this.module.redstoneControlState) {
            case 0: {
                this.setButtonTextures(this.textureAlwaysActive);
                break;
            }
            case 1: {
                this.setButtonTextures(this.textureRedstoneLow);
                break;
            }
            case 2: {
                this.setButtonTextures(this.textureRedstoneHigh);
                break;
            }
            case 3: {
                this.setButtonTextures(this.textureRedstonePulse);
            }
        }
    }

    @Override
    public void getTooltip(List<String> tooltip, int mouseX, int mouseY) {
        super.getTooltip(tooltip, mouseX, mouseY);
        if (this.isInsideBounds(mouseX, mouseY)) {
            tooltip.add(StatCollector.func_74838_a((String)(Strings.MODULE_REDSTONE_CONTROL + this.module.redstoneControlState)));
        }
    }
}

