/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.client.gui.widget.button;

import com.dynious.refinedrelocation.client.gui.IGuiParent;
import com.dynious.refinedrelocation.client.gui.widget.button.GuiButtonToggle;
import com.dynious.refinedrelocation.helper.GuiHelper;
import com.dynious.refinedrelocation.lib.Strings;
import com.dynious.refinedrelocation.tileentity.TilePowerLimiter;
import java.util.List;
import net.minecraft.util.StatCollector;

public class GuiButtonRedstoneToggle
extends GuiButtonToggle {
    protected TilePowerLimiter tile;

    public GuiButtonRedstoneToggle(IGuiParent parent, int x, int y, TilePowerLimiter tile) {
        super(parent, x, y, 24, 20, "button_redstone_high", "button_redstone_pulse", null, null);
        this.tile = tile;
        this.update();
        this.setAdventureModeRestriction(true);
    }

    @Override
    protected void onStateChangedByUser(boolean newState) {
        if (this.tile == null) {
            return;
        }
        this.tile.setRedstoneToggle(newState);
        GuiHelper.sendBooleanMessage(7, newState);
    }

    @Override
    public void getTooltip(List<String> tooltip, int mouseX, int mouseY) {
        super.getTooltip(tooltip, mouseX, mouseY);
        if (this.isInsideBounds(mouseX, mouseY)) {
            tooltip.add(StatCollector.func_74838_a((String)(this.getState() ? Strings.RS_PULSE : Strings.RS_ON)));
            tooltip.add("\u00a7e" + StatCollector.func_74838_a((String)Strings.CLICK_TO_TOGGLE));
        }
    }

    @Override
    public void update() {
        if (this.tile != null) {
            this.setState(this.tile.getRedstoneToggle());
        }
        super.update();
    }
}

