/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.client.gui.widget.button;

import com.dynious.refinedrelocation.client.gui.IGuiParent;
import com.dynious.refinedrelocation.client.gui.widget.button.GuiButtonToggle;
import com.dynious.refinedrelocation.helper.GuiHelper;
import com.dynious.refinedrelocation.lib.Strings;
import com.dynious.refinedrelocation.tileentity.IAdvancedTile;
import com.dynious.refinedrelocation.tileentity.TileBuffer;
import java.util.List;
import net.minecraft.util.StatCollector;

public class GuiButtonSpread
extends GuiButtonToggle {
    protected IAdvancedTile tile;

    public GuiButtonSpread(IGuiParent parent, int x, int y, IAdvancedTile tile) {
        super(parent, x, y, 24, 20, "button_stack", "button_spread", null, null);
        this.tile = tile;
        this.update();
        this.setAdventureModeRestriction(true);
    }

    @Override
    protected void onStateChangedByUser(boolean newState) {
        if (this.tile == null) {
            return;
        }
        this.tile.setSpreadItems(newState);
        GuiHelper.sendBooleanMessage(1, newState);
    }

    @Override
    public void getTooltip(List<String> tooltip, int mouseX, int mouseY) {
        super.getTooltip(tooltip, mouseX, mouseY);
        if (this.isInsideBounds(mouseX, mouseY)) {
            if (this.tile instanceof TileBuffer) {
                if (this.getState()) {
                    tooltip.add(StatCollector.func_74838_a((String)Strings.MODE) + ": " + StatCollector.func_74838_a((String)Strings.ROUND_ROBIN));
                    for (String s : StatCollector.func_74838_a((String)Strings.ROUND_ROBIN_DESC).split("\\\\n")) {
                        tooltip.add("\u00a77" + s);
                    }
                } else {
                    tooltip.add(StatCollector.func_74838_a((String)Strings.MODE) + ": " + StatCollector.func_74838_a((String)Strings.GREEDY));
                    for (String s : StatCollector.func_74838_a((String)Strings.GREEDY_DESC).split("\\\\n")) {
                        tooltip.add("\u00a77" + s);
                    }
                }
                tooltip.add("\u00a7e" + StatCollector.func_74838_a((String)Strings.CLICK_TO_TOGGLE));
            } else {
                String[] tooltipLines;
                tooltip.add(StatCollector.func_74838_a((String)(this.getState() ? Strings.SPREAD : Strings.STACK)));
                for (String tooltipLine : tooltipLines = StatCollector.func_74838_a((String)(this.getState() ? Strings.SPREAD_DESC : Strings.STACK_DESC)).split("\\\\n")) {
                    tooltip.add("\u00a77" + tooltipLine);
                }
                tooltip.add("\u00a7e" + StatCollector.func_74838_a((String)Strings.CLICK_TO_TOGGLE));
            }
        }
    }

    @Override
    public void update() {
        if (this.tile != null) {
            this.setState(this.tile.getSpreadItems());
        }
        super.update();
    }
}

