/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.compat;

import com.dynious.refinedrelocation.RefinedRelocation;
import com.dynious.refinedrelocation.api.ModObjects;
import com.dynious.refinedrelocation.block.BlockSortingBarrel;
import com.dynious.refinedrelocation.block.ModBlocks;
import com.dynious.refinedrelocation.lib.Settings;
import com.dynious.refinedrelocation.tileentity.TileSortingBarrel;
import com.dynious.refinedrelocation.tileentity.TileSortingChest;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import mcp.mobius.betterbarrels.BetterBarrels;
import mcp.mobius.betterbarrels.common.blocks.TileEntityBarrel;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class JabbaHelper {
    public static void enableDolly() {
        try {
            RefinedRelocation.logger.info("Attempting to patch JABBA dolly to allow picking up Sorting Chests...");
            Class<?> itemBarrelMover = Class.forName("mcp.mobius.betterbarrels.common.items.dolly.ItemBarrelMover");
            Field classExtensionNamesField = itemBarrelMover.getDeclaredField("classExtensionsNames");
            classExtensionNamesField.setAccessible(true);
            Field classExtensionsField = itemBarrelMover.getDeclaredField("classExtensions");
            classExtensionsField.setAccessible(true);
            Field classMapField = itemBarrelMover.getDeclaredField("classMap");
            classMapField.setAccessible(true);
            ArrayList classExtensions = (ArrayList)classExtensionsField.get(null);
            ArrayList classExtensionNames = (ArrayList)classExtensionNamesField.get(null);
            HashMap classMap = (HashMap)classMapField.get(null);
            if (!classExtensionNames.contains(TileSortingChest.class.getName())) {
                classExtensionNames.add(TileSortingChest.class.getName());
                classExtensions.add(TileSortingChest.class);
                classMap.put(TileSortingChest.class.getName(), TileSortingChest.class);
            }
            RefinedRelocation.logger.info("JABBA dolly should be fixed and work on Sorting Chests now!");
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            RefinedRelocation.logger.error("Could not patch JABBA dolly; internal implementation might have changed. Dolly won't work on Sorting Chest.", (Throwable)e);
        }
    }

    public static void addBarrelBlock() {
        ModBlocks.sortingBarrel = new BlockSortingBarrel();
        ModObjects.sortingBarrel = new ItemStack((Block)ModBlocks.sortingBarrel);
        GameRegistry.registerBlock((Block)ModBlocks.sortingBarrel, (String)"sortingBarrel");
    }

    public static void addBarrelRecipes() {
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Block)ModBlocks.sortingBarrel), (Object[])new Object[]{"g g", " b ", "g g", Character.valueOf('g'), Items.field_151074_bl, Character.valueOf('b'), new ItemStack(BetterBarrels.blockBarrel)});
        if (!Settings.DISABLE_SORTING_TO_NORMAL) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(BetterBarrels.blockBarrel), (Object[])new Object[]{new ItemStack((Block)ModBlocks.sortingBarrel)});
        }
    }

    public static boolean upgradeToSortingBarrel(TileEntity tile) {
        if (tile instanceof TileEntityBarrel && !(tile instanceof TileSortingBarrel)) {
            World world = tile.func_145831_w();
            TileEntityBarrel oldBarrel = (TileEntityBarrel)tile;
            int meta = oldBarrel.func_145832_p();
            TileSortingBarrel newBarrel = new TileSortingBarrel();
            NBTTagCompound tag = new NBTTagCompound();
            oldBarrel.func_145841_b(tag);
            newBarrel.func_145839_a(tag);
            world.func_147475_p(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
            world.func_147468_f(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
            world.func_147465_d(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, (Block)ModBlocks.sortingBarrel, meta, 3);
            world.func_147455_a(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, (TileEntity)newBarrel);
            return true;
        }
        return false;
    }

    public static boolean removeSortingUpgradeFromBarrel(TileSortingBarrel tile) {
        World world = tile.func_145831_w();
        int meta = tile.func_145832_p();
        TileEntityBarrel newBarrel = new TileEntityBarrel();
        NBTTagCompound tag = new NBTTagCompound();
        tile.func_145841_b(tag);
        newBarrel.func_145839_a(tag);
        world.func_147475_p(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
        world.func_147468_f(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
        world.func_147465_d(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, BetterBarrels.blockBarrel, meta, 3);
        world.func_147455_a(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, (TileEntity)newBarrel);
        return true;
    }
}

