/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.compat.waila;

import com.dynious.refinedrelocation.api.tileentity.IMultiFilterTile;
import com.dynious.refinedrelocation.api.tileentity.ISortingInventory;
import com.dynious.refinedrelocation.helper.BlockHelper;
import com.dynious.refinedrelocation.lib.Strings;
import com.dynious.refinedrelocation.tileentity.IAdvancedTile;
import com.dynious.refinedrelocation.tileentity.IDisguisable;
import com.dynious.refinedrelocation.tileentity.TileBuffer;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ITileHUDHandler
implements IWailaDataProvider {
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    public List<String> getWailaBody(ItemStack itemStatck, List<String> strings, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        NBTTagCompound compound;
        TileEntity tileEntity = accessor.getTileEntity();
        if (tileEntity instanceof IMultiFilterTile) {
            compound = accessor.getNBTData();
            List<String> wailaInfo = ((IMultiFilterTile)tileEntity).getFilter().getWAILAInformation(compound);
            if (wailaInfo != null && !wailaInfo.isEmpty()) {
                this.addToList(strings, wailaInfo);
            }
        }
        if (tileEntity instanceof ISortingInventory && (compound = accessor.getNBTData()).func_74764_b("priority")) {
            ISortingInventory.Priority priority = ISortingInventory.Priority.values()[compound.func_74771_c("priority")];
            this.addToList(strings, StatCollector.func_74838_a((String)Strings.PRIORITY) + ": " + StatCollector.func_74838_a((String)priority.name().replace('_', '-')));
        }
        if (tileEntity instanceof IAdvancedTile) {
            IAdvancedTile tile = (IAdvancedTile)accessor.getTileEntity();
            if (tile.getMaxStackSize() != -1) {
                this.addToList(strings, StatCollector.func_74837_a((String)Strings.WAILA_MAX_STACK_SIZE, (Object[])new Object[]{tile.getMaxStackSize()}));
            }
            if (tile instanceof TileBuffer) {
                if (tile.getSpreadItems()) {
                    this.addToList(strings, StatCollector.func_74838_a((String)Strings.MODE) + ": " + StatCollector.func_74838_a((String)Strings.ROUND_ROBIN));
                } else {
                    this.addToList(strings, StatCollector.func_74838_a((String)Strings.MODE) + ": " + StatCollector.func_74838_a((String)Strings.GREEDY));
                }
            } else {
                this.addToList(strings, StatCollector.func_74838_a((String)Strings.MODE) + ": " + StatCollector.func_74838_a((String)(tile.getSpreadItems() ? Strings.SPREAD : Strings.STACK)));
            }
        }
        if (tileEntity instanceof IDisguisable) {
            Block block = ((IDisguisable)tileEntity).getDisguise();
            int blockMeta = ((IDisguisable)tileEntity).getDisguiseMeta();
            if (block != null) {
                this.addToList(strings, StatCollector.func_74837_a((String)Strings.DISGUISED, (Object[])new Object[]{BlockHelper.getBlockDisplayName(block, blockMeta)}));
            }
        }
        return strings;
    }

    private void addToList(List<String> list, String string) {
        if (!list.contains(string)) {
            list.add(string);
        }
    }

    private void addToList(List<String> list, List<String> stringsToAdd) {
        for (String stringToAdd : stringsToAdd) {
            this.addToList(list, stringToAdd);
        }
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP entityPlayerMP, TileEntity tileEntity, NBTTagCompound nbtTagCompound, World world, int i, int i1, int i2) {
        if (tileEntity != null) {
            tileEntity.func_145841_b(nbtTagCompound);
        }
        return nbtTagCompound;
    }
}

