/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.container;

import com.dynious.refinedrelocation.container.ContainerHierarchical;
import com.dynious.refinedrelocation.container.IContainerAdvanced;
import com.dynious.refinedrelocation.network.packet.gui.MessageGUIBoolean;
import com.dynious.refinedrelocation.network.packet.gui.MessageGUIByte;
import com.dynious.refinedrelocation.tileentity.IAdvancedTile;
import com.dynious.refinedrelocation.tileentity.TileBlockExtender;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.player.EntityPlayer;

public class ContainerAdvanced
extends ContainerHierarchical
implements IContainerAdvanced {
    public IAdvancedTile tile;
    private boolean lastSpreadItems = false;
    private byte[] lastInsertDirection = new byte[]{1, 1, 1, 1, 1, 1, 1};
    private byte lastMaxStackSize = (byte)64;
    private boolean lastRedstoneTransmission;
    private boolean initialUpdate = true;

    public ContainerAdvanced(IAdvancedTile tile) {
        this.tile = tile;
    }

    public ContainerAdvanced(IAdvancedTile tile, ContainerHierarchical parentContainer) {
        super(parentContainer);
        this.tile = tile;
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        return true;
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (int i = 0; i < this.tile.getInsertDirection().length; ++i) {
            if (this.tile.getInsertDirection()[i] == this.lastInsertDirection[i] && !this.initialUpdate) continue;
            this.sendSyncMessage(new MessageGUIByte(11 + i, this.tile.getInsertDirection()[i]));
            this.lastInsertDirection[i] = this.tile.getInsertDirection()[i];
        }
        if (this.tile.getMaxStackSize() != this.lastMaxStackSize || this.initialUpdate) {
            this.sendSyncMessage(new MessageGUIByte(2, this.tile.getMaxStackSize()));
            this.lastMaxStackSize = this.tile.getMaxStackSize();
        }
        if (this.tile.getSpreadItems() != this.lastSpreadItems || this.initialUpdate) {
            this.sendSyncMessage(new MessageGUIBoolean(1, this.tile.getSpreadItems()));
            this.lastSpreadItems = this.tile.getSpreadItems();
        }
        if (this.tile instanceof TileBlockExtender) {
            boolean redstoneTransmissionEnabled = ((TileBlockExtender)((Object)this.tile)).isRedstoneTransmissionEnabled();
            if (this.tile instanceof TileBlockExtender && redstoneTransmissionEnabled != this.lastRedstoneTransmission || this.initialUpdate) {
                this.sendSyncMessage(new MessageGUIBoolean(9, redstoneTransmissionEnabled));
                this.lastRedstoneTransmission = redstoneTransmissionEnabled;
            }
        }
        if (this.initialUpdate) {
            this.initialUpdate = false;
        }
    }

    @Override
    public void setInsertDirection(int from, int value) {
        this.tile.setInsertDirection(from, value);
        this.lastInsertDirection[from] = (byte)value;
    }

    @Override
    public void setMaxStackSize(byte maxStackSize) {
        this.tile.setMaxStackSize(maxStackSize);
        this.lastMaxStackSize = maxStackSize;
    }

    @Override
    public void setSpreadItems(boolean spreadItems) {
        this.tile.setSpreadItems(spreadItems);
        this.lastSpreadItems = spreadItems;
    }

    public void setRedstoneTransmissionEnabled(boolean redstoneTransmissionEnabled) {
        if (this.tile instanceof TileBlockExtender) {
            ((TileBlockExtender)((Object)this.tile)).setRedstoneTransmissionEnabled(redstoneTransmissionEnabled);
        }
        this.lastRedstoneTransmission = redstoneTransmissionEnabled;
    }

    @Override
    public void onMessageBoolean(int messageId, boolean value, EntityPlayer player, Side side) {
        if (ContainerAdvanced.isRestrictedAccessWithError(player)) {
            return;
        }
        switch (messageId) {
            case 1: {
                this.setSpreadItems(value);
                break;
            }
            case 9: {
                this.setRedstoneTransmissionEnabled(value);
            }
        }
    }

    @Override
    public void onMessageByte(int messageId, byte value, EntityPlayer player, Side side) {
        if (ContainerAdvanced.isRestrictedAccessWithError(player)) {
            return;
        }
        if (messageId >= 11 && messageId <= 16) {
            this.setInsertDirection(messageId - 11, value);
            return;
        }
        switch (messageId) {
            case 2: {
                this.setMaxStackSize(value);
            }
        }
    }
}

