/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.container;

import com.dynious.refinedrelocation.api.filter.IFilterGUI;
import com.dynious.refinedrelocation.container.ContainerAdvanced;
import com.dynious.refinedrelocation.container.ContainerFiltered;
import com.dynious.refinedrelocation.container.ContainerHierarchical;
import com.dynious.refinedrelocation.container.IContainerAdvanced;
import com.dynious.refinedrelocation.container.IContainerAdvancedFiltered;
import com.dynious.refinedrelocation.container.IContainerFiltered;
import com.dynious.refinedrelocation.network.packet.gui.MessageGUIBoolean;
import com.dynious.refinedrelocation.tileentity.IAdvancedFilteredTile;
import com.dynious.refinedrelocation.tileentity.TileBlockExtender;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.player.EntityPlayer;

public class ContainerAdvancedFiltered
extends ContainerHierarchical
implements IContainerAdvancedFiltered {
    public IAdvancedFilteredTile tile;
    private IContainerFiltered containerFiltered;
    private IContainerAdvanced containerAdvanced;
    private boolean lastRestrictExtraction = false;
    private boolean initialUpdate = true;

    public ContainerAdvancedFiltered(IAdvancedFilteredTile tile) {
        this.tile = tile;
        this.containerFiltered = new ContainerFiltered(tile, this);
        this.containerAdvanced = new ContainerAdvanced(tile, this);
    }

    public ContainerAdvancedFiltered(IAdvancedFilteredTile tile, ContainerHierarchical parentContainer) {
        super(parentContainer);
        this.tile = tile;
        this.containerFiltered = new ContainerFiltered(tile, this);
        this.containerAdvanced = new ContainerAdvanced(tile, this);
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        return true;
    }

    public void func_75142_b() {
        ((ContainerAdvanced)this.containerAdvanced).func_75142_b();
        ((ContainerFiltered)this.containerFiltered).func_75142_b();
        if (this.tile.getRestrictExtraction() != this.lastRestrictExtraction || this.initialUpdate) {
            this.sendSyncMessage(new MessageGUIBoolean(3, this.tile.getRestrictExtraction()));
            this.lastRestrictExtraction = this.tile.getRestrictExtraction();
        }
        if (this.initialUpdate) {
            this.initialUpdate = false;
        }
    }

    @Override
    public void setRestrictExtraction(boolean restrictExtraction) {
        this.tile.setRestrictionExtraction(restrictExtraction);
        this.lastRestrictExtraction = restrictExtraction;
    }

    @Override
    public void setPriority(int priority) {
    }

    @Override
    public IFilterGUI getFilter() {
        return this.tile.getFilter();
    }

    @Override
    public void setInsertDirection(int from, int value) {
        this.containerAdvanced.setInsertDirection(from, value);
    }

    @Override
    public void setMaxStackSize(byte maxStackSize) {
        this.containerAdvanced.setMaxStackSize(maxStackSize);
    }

    @Override
    public void setSpreadItems(boolean spreadItems) {
        this.containerAdvanced.setSpreadItems(spreadItems);
    }

    @Override
    public void onMessageByte(int messageId, byte value, EntityPlayer player, Side side) {
        if (ContainerAdvancedFiltered.isRestrictedAccessWithError(player)) {
            return;
        }
        if (messageId >= 11 && messageId <= 16) {
            this.setInsertDirection(messageId - 11, value);
            return;
        }
        if (messageId == 2) {
            this.setMaxStackSize(value);
        }
    }

    @Override
    public void onMessageBoolean(int messageId, boolean value, EntityPlayer player, Side side) {
        if (ContainerAdvancedFiltered.isRestrictedAccessWithError(player)) {
            return;
        }
        switch (messageId) {
            case 1: {
                this.setSpreadItems(value);
                break;
            }
            case 3: {
                this.setRestrictExtraction(value);
                break;
            }
            case 9: {
                if (!(this.tile instanceof TileBlockExtender)) break;
                ((TileBlockExtender)((Object)this.tile)).setRedstoneTransmissionEnabled(value);
            }
        }
    }
}

