/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.grid.filter;

import com.dynious.refinedrelocation.api.filter.IChecklistFilter;
import com.dynious.refinedrelocation.api.gui.IGuiWidgetWrapped;
import com.dynious.refinedrelocation.client.graphics.TextureRegion;
import com.dynious.refinedrelocation.client.gui.SharedAtlas;
import com.dynious.refinedrelocation.client.gui.widget.GuiFilterList;
import com.dynious.refinedrelocation.grid.filter.MultiFilterChildBase;
import com.dynious.refinedrelocation.handler.LoginSyncHandler;
import com.dynious.refinedrelocation.lib.Strings;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;

public class CreativeTabFilter
extends MultiFilterChildBase
implements IChecklistFilter {
    public static final String TYPE_NAME = "creative";
    private static TextureRegion iconTexture;
    public static String[] serverSideTabLabels;
    private boolean[] tabStates;

    public static void syncTabLabels(String[] tabLabels) {
        serverSideTabLabels = tabLabels;
    }

    public CreativeTabFilter() {
        if (serverSideTabLabels == null) {
            serverSideTabLabels = LoginSyncHandler.getCreativeTabLabels();
        }
        this.tabStates = new boolean[serverSideTabLabels.length];
    }

    @Override
    public boolean isInFilter(ItemStack itemStack) {
        CreativeTabs tab = itemStack.func_77973_b() instanceof ItemBlock ? Block.func_149729_e((int)ItemBlock.func_150891_b((Item)itemStack.func_77973_b())).field_149772_a : itemStack.func_77973_b().field_77701_a;
        return tab != null && tab.field_78033_n < this.tabStates.length && this.tabStates[tab.field_78033_n];
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.tabStates.length; ++i) {
            if (!this.tabStates[i]) continue;
            tagList.func_74742_a((NBTBase)new NBTTagString(serverSideTabLabels[i]));
        }
        compound.func_74782_a("tabStates", (NBTBase)tagList);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        NBTTagList tagList = compound.func_150295_c("tabStates", 8);
        block0: for (int i = 0; i < tagList.func_74745_c(); ++i) {
            String tabLabel = tagList.func_150307_f(i);
            for (int j = 0; j < serverSideTabLabels.length; ++j) {
                if (!serverSideTabLabels[j].equals(tabLabel)) continue;
                this.tabStates[j] = true;
                continue block0;
            }
        }
    }

    @Override
    public void sendUpdate(EntityPlayerMP playerMP) {
        this.getParentFilter().sendBooleanArrayToPlayer(this, playerMP, 0, this.tabStates);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IGuiWidgetWrapped getGuiWidget(int x, int y, int width, int height) {
        return new GuiFilterList(x, y, width, height, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getIconSheet() {
        if (iconTexture == null) {
            iconTexture = SharedAtlas.findRegion("icon_filter_creative");
        }
        return CreativeTabFilter.iconTexture.texture;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getIconX() {
        return iconTexture.getRegionX();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getIconY() {
        return iconTexture.getRegionY();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getIconWidth() {
        return iconTexture.getRegionWidth();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getIconHeight() {
        return iconTexture.getRegionHeight();
    }

    @Override
    public void setFilterBooleanArray(int optionId, boolean[] values) {
        this.tabStates = values;
    }

    @Override
    public void setFilterBoolean(int optionId, boolean value) {
        this.tabStates[optionId] = value;
    }

    @Override
    public void setFilterString(int optionId, String value) {
    }

    @Override
    public String getName(int index) {
        return I18n.func_135052_a((String)("itemGroup." + serverSideTabLabels[index]), (Object[])new Object[0]).replace("itemGroup.", "");
    }

    @Override
    public void setValue(int optionIndex, boolean value) {
        this.tabStates[optionIndex] = value;
        this.markDirty(true);
    }

    @Override
    public boolean getValue(int optionIndex) {
        return this.tabStates[optionIndex];
    }

    @Override
    public int getOptionCount() {
        return this.tabStates.length;
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getNameLangKey() {
        return Strings.CREATIVE_FILTER;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getDescriptionLangKey() {
        return Strings.CREATIVE_FILTER_DESCRIPTION;
    }
}

