/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.grid.relocator;

import com.dynious.refinedrelocation.api.relocator.IRelocatorModule;
import com.dynious.refinedrelocation.grid.relocator.ItemOrPaths;
import com.dynious.refinedrelocation.grid.relocator.PathToRelocator;
import com.dynious.refinedrelocation.grid.relocator.TravellingItem;
import com.dynious.refinedrelocation.helper.IOHelper;
import com.dynious.refinedrelocation.tileentity.IRelocator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class RelocatorGridLogic {
    private static List<TileEntity> checkedRelocators = new ArrayList<TileEntity>();

    public static TravellingItem findOutput(ItemStack itemStack, IRelocator relocator, int side) {
        PathToRelocator path = new PathToRelocator(relocator, new ArrayList<Byte>(Arrays.asList((byte)side)));
        ItemOrPaths itemOrPaths = RelocatorGridLogic.tryOutputAndReturnConnections(itemStack, path, null, side);
        if (itemOrPaths.ITEM != null) {
            checkedRelocators.clear();
            return itemOrPaths.ITEM;
        }
        while (!itemOrPaths.PATHS.isEmpty()) {
            ListIterator<PathToRelocator> iterator = itemOrPaths.PATHS.listIterator();
            while (iterator.hasNext()) {
                PathToRelocator pathToRelocator = iterator.next();
                ItemOrPaths itemOrPaths2 = RelocatorGridLogic.tryOutputAndReturnConnections(itemStack, pathToRelocator, itemOrPaths, ForgeDirection.OPPOSITES[pathToRelocator.PATH.get(pathToRelocator.PATH.size() - 1)]);
                if (itemOrPaths2.ITEM != null) {
                    checkedRelocators.clear();
                    return itemOrPaths2.ITEM;
                }
                iterator.remove();
                for (PathToRelocator path2 : itemOrPaths2.PATHS) {
                    iterator.add(path2);
                }
            }
        }
        checkedRelocators.clear();
        return null;
    }

    private static ItemOrPaths tryOutputAndReturnConnections(ItemStack itemStack, PathToRelocator path, ItemOrPaths currentPaths, int excludedOutputSide) {
        TravellingItem item = RelocatorGridLogic.tryToOutput(itemStack, path, excludedOutputSide);
        if (item != null) {
            return new ItemOrPaths(item);
        }
        checkedRelocators.add(path.RELOCATOR.getTileEntity());
        ArrayList<PathToRelocator> uncheckedRelocators = new ArrayList<PathToRelocator>();
        for (int i = 0; i < path.RELOCATOR.getConnectedRelocators().length; ++i) {
            IRelocator relocator1 = path.RELOCATOR.getConnectedRelocators()[i];
            if (relocator1 == null || checkedRelocators.contains(relocator1.getTileEntity()) || currentPaths != null && RelocatorGridLogic.doesListContainTile(currentPaths.PATHS, relocator1.getTileEntity()) || !path.RELOCATOR.passesFilter(itemStack, i, false, true)) continue;
            IRelocatorModule module = path.RELOCATOR.getRelocatorModule(i);
            if (module != null && module.isItemDestination()) {
                ItemStack stack = module.receiveItemStack(path.RELOCATOR, i, itemStack.func_77946_l(), false, true);
                if (stack != null && stack.field_77994_a >= itemStack.field_77994_a) continue;
                ArrayList newPath = (ArrayList)path.PATH.clone();
                newPath.add((byte)i);
                if (stack != null) {
                    stack.field_77994_a = itemStack.field_77994_a - stack.field_77994_a;
                } else {
                    stack = itemStack.func_77946_l();
                }
                return new ItemOrPaths(new TravellingItem(stack, newPath));
            }
            if (!relocator1.passesFilter(itemStack, ForgeDirection.OPPOSITES[i], true, true)) continue;
            IRelocatorModule module1 = relocator1.getRelocatorModule(ForgeDirection.OPPOSITES[i]);
            if (module1 != null && module1.isItemDestination()) {
                ItemStack stack = module1.receiveItemStack(relocator1, ForgeDirection.OPPOSITES[i], itemStack.func_77946_l(), true, true);
                if (stack != null && stack.field_77994_a >= itemStack.field_77994_a) continue;
                ArrayList newPath = (ArrayList)path.PATH.clone();
                newPath.add((byte)i);
                if (stack != null) {
                    stack.field_77994_a = itemStack.field_77994_a - stack.field_77994_a;
                } else {
                    stack = itemStack.func_77946_l();
                }
                return new ItemOrPaths(new TravellingItem(stack, newPath));
            }
            ArrayList newP = (ArrayList)path.PATH.clone();
            newP.add((byte)i);
            uncheckedRelocators.add(new PathToRelocator(relocator1, newP));
        }
        return new ItemOrPaths(uncheckedRelocators);
    }

    private static TravellingItem tryToOutput(ItemStack itemStack, PathToRelocator path, int excludedSide) {
        for (int i = 0; i < path.RELOCATOR.getConnectedInventories().length; ++i) {
            ItemStack stack;
            if (i == excludedSide) continue;
            IRelocatorModule module = path.RELOCATOR.getRelocatorModule(i);
            if (module != null && module.isItemDestination()) {
                ItemStack stack2 = module.receiveItemStack(path.RELOCATOR, i, itemStack.func_77946_l(), false, true);
                if (stack2 != null && stack2.field_77994_a >= itemStack.field_77994_a) continue;
                ArrayList newPath = (ArrayList)path.PATH.clone();
                newPath.add((byte)i);
                if (stack2 != null) {
                    stack2.field_77994_a = itemStack.field_77994_a - stack2.field_77994_a;
                } else {
                    stack2 = itemStack.func_77946_l();
                }
                return new TravellingItem(stack2, newPath);
            }
            TileEntity inventory = path.RELOCATOR.getConnectedInventories()[i];
            if (inventory == null || !path.RELOCATOR.passesFilter(itemStack, i, false, true) || (stack = module != null ? module.outputToSide(path.RELOCATOR, i, inventory, itemStack.func_77946_l(), true) : IOHelper.insert(inventory, itemStack.func_77946_l(), ForgeDirection.getOrientation((int)i).getOpposite(), true)) != null && stack.field_77994_a >= itemStack.field_77994_a) continue;
            ArrayList newPath = (ArrayList)path.PATH.clone();
            newPath.add((byte)i);
            if (stack != null) {
                stack.field_77994_a = itemStack.field_77994_a - stack.field_77994_a;
            } else {
                stack = itemStack.func_77946_l();
            }
            return new TravellingItem(stack, newPath);
        }
        return null;
    }

    public static boolean doesListContainTile(List<PathToRelocator> uncheckedRelocators, TileEntity tile) {
        for (PathToRelocator path : uncheckedRelocators) {
            if (path.RELOCATOR.getTileEntity() != tile) continue;
            return true;
        }
        return false;
    }
}

