/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.grid.relocator;

import com.dynious.refinedrelocation.api.APIUtils;
import com.dynious.refinedrelocation.api.relocator.IItemRelocator;
import com.dynious.refinedrelocation.api.relocator.RelocatorModuleBase;
import com.dynious.refinedrelocation.client.gui.GuiModuleExtraction;
import com.dynious.refinedrelocation.container.ContainerModuleExtraction;
import com.dynious.refinedrelocation.helper.IOHelper;
import com.dynious.refinedrelocation.helper.StringHelper;
import com.dynious.refinedrelocation.item.ModItems;
import com.dynious.refinedrelocation.lib.Resources;
import com.dynious.refinedrelocation.lib.Settings;
import com.dynious.refinedrelocation.lib.Strings;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;

public class RelocatorModuleExtraction
extends RelocatorModuleBase {
    private static IIcon icon;
    public int redstoneControlState = 0;
    public int maxExtractionStackSize = 64;
    protected int lastCheckedSlot = -1;
    private byte tick = 0;
    private int ticksBetweenExtraction = Settings.RELOCATOR_MIN_TICKS_BETWEEN_EXTRACTION;
    private boolean isPowered = false;
    private boolean hasHadPulse = false;

    public RelocatorModuleExtraction() {
        super(new ItemStack((Item)ModItems.relocatorModule, 1, 3));
    }

    public RelocatorModuleExtraction(ItemStack moduleStack) {
        super(moduleStack);
    }

    @Override
    public void init(IItemRelocator relocator, int side) {
        super.init(relocator, side);
    }

    @Override
    public boolean onActivated(IItemRelocator relocator, EntityPlayer player, int side, ItemStack stack) {
        APIUtils.openRelocatorModuleGUI(relocator, player, side);
        return true;
    }

    @Override
    public void onUpdate(IItemRelocator relocator, int side) {
        TileEntity tile;
        this.tick = (byte)(this.tick + 1);
        if (this.tick >= this.ticksBetweenExtraction && (tile = relocator.getConnectedInventories()[side]) instanceof IInventory) {
            switch (this.redstoneControlState) {
                case 0: {
                    this.tryExtraction(relocator, (IInventory)tile, this.getExtractionSide(side), side, this.lastCheckedSlot);
                    this.tick = 0;
                    break;
                }
                case 1: {
                    if (this.isPowered) break;
                    this.tryExtraction(relocator, (IInventory)tile, this.getExtractionSide(side), side, this.lastCheckedSlot);
                    this.tick = 0;
                    break;
                }
                case 2: {
                    if (!this.isPowered) break;
                    this.tryExtraction(relocator, (IInventory)tile, this.getExtractionSide(side), side, this.lastCheckedSlot);
                    this.tick = 0;
                    break;
                }
                case 3: {
                    if (!this.hasHadPulse) break;
                    this.tryExtraction(relocator, (IInventory)tile, this.getExtractionSide(side), side, this.lastCheckedSlot);
                    this.tick = 0;
                    this.hasHadPulse = false;
                }
            }
        }
    }

    @Override
    public void onRedstonePowerChange(boolean isPowered) {
        this.isPowered = isPowered;
        if (isPowered) {
            this.hasHadPulse = true;
        }
        super.onRedstonePowerChange(isPowered);
    }

    @Override
    public boolean connectsToRedstone() {
        return true;
    }

    protected int getExtractionSide(int side) {
        return ForgeDirection.OPPOSITES[side];
    }

    public void tryExtraction(IItemRelocator relocator, IInventory inventory, int extractionSide, int connectedSide, int firstChecked) {
        int slot = this.getNextSlot(inventory, ForgeDirection.getOrientation((int)extractionSide));
        if (slot != -1) {
            ItemStack stack = inventory.func_70301_a(slot);
            if (stack != null && stack.field_77994_a != 0) {
                if (IOHelper.canExtractItemFromInventory(inventory, stack, slot, extractionSide)) {
                    ItemStack stackCopy = stack.func_77946_l();
                    stackCopy.field_77994_a = Math.min(this.maxExtractionStackSize, stackCopy.field_77994_a);
                    int returnedStackExtra = stack.field_77994_a - stackCopy.field_77994_a;
                    ItemStack returnedStack = relocator.insert(stackCopy, connectedSide, false);
                    if (returnedStack == null || stack.field_77994_a != returnedStack.field_77994_a) {
                        if (returnedStack != null) {
                            returnedStack.field_77994_a = Math.min(returnedStack.field_77994_a + returnedStackExtra, returnedStack.func_77976_d());
                        } else if (returnedStackExtra > 0) {
                            returnedStack = stackCopy;
                            returnedStack.field_77994_a = returnedStackExtra;
                        }
                        inventory.func_70299_a(slot, returnedStack);
                    }
                }
            } else if (firstChecked != this.lastCheckedSlot) {
                if (firstChecked == -1) {
                    firstChecked = this.lastCheckedSlot;
                }
                this.tryExtraction(relocator, inventory, extractionSide, connectedSide, firstChecked);
            }
        }
    }

    public int getNextSlot(IInventory inventory, ForgeDirection direction) {
        if (inventory instanceof ISidedInventory) {
            ISidedInventory isidedinventory = (ISidedInventory)inventory;
            int[] accessibleSlotsFromSide = isidedinventory.func_94128_d(direction.ordinal());
            this.lastCheckedSlot = this.lastCheckedSlot < accessibleSlotsFromSide.length - 1 ? ++this.lastCheckedSlot : 0;
            return this.lastCheckedSlot < accessibleSlotsFromSide.length ? accessibleSlotsFromSide[this.lastCheckedSlot] : -1;
        }
        this.lastCheckedSlot = this.lastCheckedSlot < inventory.func_70302_i_() - 1 ? ++this.lastCheckedSlot : 0;
        return this.lastCheckedSlot;
    }

    public int getTicksBetweenExtraction() {
        return this.ticksBetweenExtraction;
    }

    public void setTicksBetweenExtraction(int ticks) {
        this.ticksBetweenExtraction = Math.max(Settings.RELOCATOR_MIN_TICKS_BETWEEN_EXTRACTION, ticks);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGUI(IItemRelocator relocator, int side, EntityPlayer player) {
        return new GuiModuleExtraction(this);
    }

    @Override
    public Container getContainer(IItemRelocator relocator, int side, EntityPlayer player) {
        return new ContainerModuleExtraction(this);
    }

    @Override
    public void readFromNBT(IItemRelocator relocator, int side, NBTTagCompound compound) {
        this.ticksBetweenExtraction = compound.func_74762_e("ticksBetweenExt");
        this.redstoneControlState = compound.func_74762_e("redstoneControlState");
        if (compound.func_74764_b("maxExtractionStackSize")) {
            this.maxExtractionStackSize = compound.func_74762_e("maxExtractionStackSize");
        }
    }

    @Override
    public void writeToNBT(IItemRelocator relocator, int side, NBTTagCompound compound) {
        compound.func_74768_a("ticksBetweenExt", this.ticksBetweenExtraction);
        compound.func_74768_a("redstoneControlState", this.redstoneControlState);
        compound.func_74768_a("maxExtractionStackSize", this.maxExtractionStackSize);
    }

    @Override
    public List<ItemStack> getDrops(IItemRelocator relocator, int side) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack((Item)ModItems.relocatorModule, 1, 3));
        return list;
    }

    @Override
    public String getDisplayName() {
        return StatCollector.func_74838_a((String)"item.relocatorModule3.name");
    }

    @Override
    public IIcon getIcon(IItemRelocator relocator, int side) {
        return icon;
    }

    @Override
    public void registerIcons(IIconRegister register) {
        icon = register.func_94245_a(Resources.MOD_ID + ":relocatorModuleExtraction");
    }

    @Override
    public List<String> getWailaInformation(NBTTagCompound nbtData) {
        ArrayList<String> information = new ArrayList<String>();
        information.add(StatCollector.func_74837_a((String)Strings.WAILA_MAX_STACK_SIZE, (Object[])new Object[]{nbtData.func_74762_e("maxExtractionStackSize")}));
        information.add(StatCollector.func_74837_a((String)Strings.WAILA_REDSTONE_CONTROL, (Object[])new Object[]{StringHelper.getLocalizedString(Strings.MODULE_REDSTONE_CONTROL + nbtData.func_74762_e("redstoneControlState"))}));
        return information;
    }
}

