/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.grid.sorting;

import com.dynious.refinedrelocation.api.tileentity.IInventoryChangeListener;
import com.dynious.refinedrelocation.api.tileentity.ISortingInventory;
import com.dynious.refinedrelocation.api.tileentity.ISpecialSortingInventory;
import com.dynious.refinedrelocation.api.tileentity.grid.ISortingGrid;
import com.dynious.refinedrelocation.api.tileentity.grid.LocalizedStack;
import com.dynious.refinedrelocation.api.tileentity.handlers.IGridMemberHandler;
import com.dynious.refinedrelocation.grid.Grid;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class SortingGrid
extends Grid
implements ISortingGrid {
    @Override
    public ItemStack filterStackToGroup(ItemStack itemStack, TileEntity requester, int slot, boolean simulate) {
        if (this.members != null && !this.members.isEmpty()) {
            List<List<ISortingInventory>> sortingList = this.createSortingList(requester);
            for (List<ISortingInventory> list : sortingList) {
                for (ISortingInventory inventory : list) {
                    if (!inventory.getFilter().passesFilter(itemStack)) continue;
                    if (inventory == requester) {
                        return itemStack;
                    }
                    if ((itemStack = inventory.putInInventory(itemStack, simulate)) != null && itemStack.field_77994_a != 0) continue;
                    return null;
                }
            }
        }
        return itemStack;
    }

    private List<List<ISortingInventory>> createSortingList(TileEntity requester) {
        ArrayList<List<ISortingInventory>> list = new ArrayList<List<ISortingInventory>>();
        for (ISortingInventory.Priority ignored : ISortingInventory.Priority.values()) {
            list.add(new ArrayList());
        }
        Iterator iterator = this.members.iterator();
        while (iterator.hasNext()) {
            IGridMemberHandler filteringMember = (IGridMemberHandler)iterator.next();
            if (filteringMember.getOwner().func_145837_r()) {
                iterator.remove();
                continue;
            }
            if (!(filteringMember.getOwner() instanceof ISortingInventory)) continue;
            ISortingInventory filteringInventory = (ISortingInventory)filteringMember.getOwner();
            if (filteringInventory == requester) {
                ((List)list.get(filteringInventory.getPriority().ordinal())).add(0, filteringInventory);
                continue;
            }
            ((List)list.get(filteringInventory.getPriority().ordinal())).add(filteringInventory);
        }
        return list;
    }

    @Override
    public List<LocalizedStack> getItemsInGrid() {
        ArrayList<LocalizedStack> list = new ArrayList<LocalizedStack>();
        if (this.members != null) {
            for (IGridMemberHandler member : this.members) {
                if (!(member.getOwner() instanceof ISortingInventory)) continue;
                ISortingInventory inventory = (ISortingInventory)member.getOwner();
                for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
                    ItemStack stack = inventory.func_70301_a(slot);
                    if (stack == null) continue;
                    if (inventory instanceof ISpecialSortingInventory) {
                        list.add(((ISpecialSortingInventory)inventory).getLocalizedStackInSlot(slot));
                        continue;
                    }
                    list.add(new LocalizedStack(stack, inventory, slot));
                }
            }
        }
        return list;
    }

    @Override
    public void onInventoryChange() {
        if (this.members != null) {
            for (IGridMemberHandler member : this.members) {
                if (!(member.getOwner() instanceof IInventoryChangeListener)) continue;
                ((IInventoryChangeListener)member.getOwner()).onInventoryChanged();
            }
        }
    }
}

