/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.item;

import com.dynious.refinedrelocation.RefinedRelocation;
import com.dynious.refinedrelocation.lib.Mods;
import com.dynious.refinedrelocation.lib.Resources;
import com.dynious.refinedrelocation.lib.Strings;
import com.dynious.refinedrelocation.repack.codechicken.lib.raytracer.RayTracer;
import ic2.api.item.ElectricItem;
import java.util.ArrayList;
import java.util.List;
import mcp.mobius.waila.api.SpecialChars;
import mcp.mobius.waila.utils.ModIdentification;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class ItemToolBox
extends Item {
    private static final String[] WRENCH_CLASS_NAMES = new String[]{"ic2.core.item.tool.ItemToolWrench", "ic2.core.item.tool.ItemToolMeter", "buildcraft.api.tools.IToolWrench", "appeng.api.implementations.items.IAEWrench", "thermalexpansion.item.tool.ItemWrench", "com.carpentersblocks.api.ICarpentersChisel", "com.carpentersblocks.api.ICarpentersHammer", "com.iconmaster.aec.item.ItemAetometer", "factorization.charge.ItemChargeMeter", "mekanism.common.item.ItemConfigurator", "mekanism.common.item.ItemNetworkReader", "mrtjp.projectred.api.IScrewdriver", "com.yogpc.qp.ItemTool", "redstonearsenal.item.tool.ItemWrenchRF", "redstonearsenal.item.tool.ItemWrenchBattleRF", "aroma1997.core.items.wrench.ItemWrench"};
    private static final List<Class<?>> wrenchClasses = new ArrayList();

    public static void addToolboxClass(Class clazz) {
        if (clazz != null && !wrenchClasses.contains(clazz)) {
            wrenchClasses.add(clazz);
        }
    }

    public ItemToolBox() {
        this.func_77655_b("toolbox");
        this.func_77637_a(RefinedRelocation.tabRefinedRelocation);
        this.func_77625_d(1);
        this.func_77642_a(this);
        for (String className : WRENCH_CLASS_NAMES) {
            try {
                wrenchClasses.add(Class.forName(className));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    public boolean isItemWrench(Item item) {
        for (Class<?> clazz : wrenchClasses) {
            if (!clazz.isAssignableFrom(item.getClass())) continue;
            return true;
        }
        return false;
    }

    public boolean doesToolBoxContainWrench(NBTTagCompound toolBoxCompound, ItemStack wrenchStack) {
        NBTTagList tagList = toolBoxCompound.func_150295_c("wrenches", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = tagList.func_150305_b(i);
            ItemStack itemStack = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
            if (!(itemStack.func_77981_g() ? itemStack.func_77969_a(wrenchStack) : itemStack.func_77973_b() == wrenchStack.func_77973_b())) continue;
            return true;
        }
        return false;
    }

    public ItemStack getCurrentWrench(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
            NBTTagList tagList = itemStack.func_77978_p().func_150295_c("wrenches", 10);
            byte index = itemStack.func_77978_p().func_74771_c("index");
            if (tagList.func_74745_c() > index) {
                NBTTagCompound tagCompound = tagList.func_150305_b((int)index);
                return ItemStack.func_77949_a((NBTTagCompound)tagCompound);
            }
        }
        return null;
    }

    public ArrayList<ItemStack> getWrenches(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
            ArrayList<ItemStack> wrenches = new ArrayList<ItemStack>();
            NBTTagList list = itemStack.func_77978_p().func_150295_c("wrenches", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tagCompound = list.func_150305_b(i);
                wrenches.add(ItemStack.func_77949_a((NBTTagCompound)tagCompound));
            }
            return wrenches;
        }
        return null;
    }

    public void addWrenchAtIndex(ItemStack itemStack, ItemStack wrenchStack, int index) {
        NBTTagList tagList;
        if (wrenchStack == null || wrenchStack.field_77994_a == 0) {
            this.removeWrenchAtIndex(itemStack, index);
            return;
        }
        if (itemStack.func_77942_o() && (tagList = itemStack.func_77978_p().func_150295_c("wrenches", 10)).func_74745_c() > index) {
            NBTTagCompound tagCompound = tagList.func_150305_b(index);
            wrenchStack.func_77955_b(tagCompound);
        }
    }

    public void removeWrenchAtIndex(ItemStack itemStack, int index) {
        NBTTagList tagList;
        if (itemStack.func_77942_o() && (tagList = itemStack.func_77978_p().func_150295_c("wrenches", 10)).func_74745_c() > index) {
            tagList.func_74744_a(index);
            if (--index < 0) {
                index = 0;
            }
            itemStack.func_77978_p().func_74774_a("index", (byte)index);
        }
    }

    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        ItemStack wrenchStack = this.getCurrentWrench(player.func_70694_bm());
        return wrenchStack != null && wrenchStack.func_77973_b().doesSneakBypassUse(world, x, y, z, player);
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        MovingObjectPosition mop = RayTracer.reTrace(world, entityPlayer);
        if (!itemStack.func_77942_o()) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74782_a("wrenches", (NBTBase)new NBTTagList());
            tagCompound.func_74774_a("index", (byte)0);
            itemStack.func_77982_d(tagCompound);
        }
        if (entityPlayer.func_70093_af()) {
            ItemStack[] mainInventory = entityPlayer.field_71071_by.field_70462_a;
            for (int i = 0; i < mainInventory.length; ++i) {
                ItemStack invStack = mainInventory[i];
                if (invStack == null || !this.isItemWrench(invStack.func_77973_b()) || this.doesToolBoxContainWrench(itemStack.func_77978_p(), invStack)) continue;
                NBTTagList tagList = itemStack.func_77978_p().func_150295_c("wrenches", 10);
                NBTTagCompound tagCompound = new NBTTagCompound();
                ItemStack wrenchStack = invStack.func_77979_a(1);
                wrenchStack.func_77955_b(tagCompound);
                tagList.func_74742_a((NBTBase)tagCompound);
                if (invStack.field_77994_a != 0) continue;
                entityPlayer.field_71071_by.func_70299_a(i, null);
            }
            if (mop == null || mop.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
                ArrayList<ItemStack> wrenches;
                int index = itemStack.func_77978_p().func_74771_c("index");
                if (++index >= itemStack.func_77978_p().func_150295_c("wrenches", 10).func_74745_c()) {
                    index = 0;
                }
                itemStack.func_77978_p().func_74774_a("index", (byte)index);
                if (!world.field_72995_K && !(wrenches = this.getWrenches(itemStack)).isEmpty()) {
                    ItemStack currentWrench = this.getCurrentWrench(itemStack);
                    StringBuilder sb = new StringBuilder(StatCollector.func_74838_a((String)Strings.TOOLBOX_WRENCH_LIST_START)).append(" ");
                    for (int i = 0; i < wrenches.size(); ++i) {
                        ItemStack wrenchStack;
                        if (i > 0) {
                            sb.append(".");
                        }
                        if ((wrenchStack = wrenches.get(i)).func_77981_g() ? wrenchStack.func_77969_a(currentWrench) : wrenchStack.func_77973_b() == currentWrench.func_77973_b()) {
                            sb.append("\u00a7a");
                        }
                        sb.append(wrenchStack.func_82833_r()).append("\u00a7r");
                    }
                    entityPlayer.func_145747_a((IChatComponent)new ChatComponentText(sb.toString()));
                }
            }
        }
        return itemStack;
    }

    public boolean onItemUseFirst(ItemStack itemStack, EntityPlayer entityPlayer, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!itemStack.func_77942_o()) {
            return false;
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        byte index = tagCompound.func_74771_c("index");
        ItemStack wrenchStack = this.getCurrentWrench(itemStack);
        if (wrenchStack != null) {
            if (wrenchStack.func_77973_b().onItemUseFirst(itemStack, entityPlayer, world, x, y, z, side, hitX, hitY, hitZ)) {
                return true;
            }
            Block block = world.func_147439_a(x, y, z);
            if (block != null) {
                entityPlayer.field_71071_by.field_70462_a[entityPlayer.field_71071_by.field_70461_c] = wrenchStack;
                if (!wrenchStack.func_77973_b().onItemUseFirst(wrenchStack, entityPlayer, world, x, y, z, side, hitX, hitY, hitZ)) {
                    block.func_149727_a(world, x, y, z, entityPlayer, side, hitX, hitY, hitZ);
                }
                this.addWrenchAtIndex(itemStack, entityPlayer.func_71045_bC(), index);
                entityPlayer.field_71071_by.field_70462_a[entityPlayer.field_71071_by.field_70461_c] = itemStack;
                return true;
            }
        }
        return false;
    }

    public boolean func_77648_a(ItemStack itemStack, EntityPlayer entityPlayer, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!itemStack.func_77942_o()) {
            return false;
        }
        ItemStack wrenchStack = this.getCurrentWrench(itemStack);
        return wrenchStack != null && wrenchStack.func_77973_b().func_77648_a(itemStack, entityPlayer, world, x, y, z, side, hitX, hitY, hitZ);
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean flag) {
        ItemStack wrenchStack = this.getCurrentWrench(itemStack);
        if (wrenchStack != null) {
            String charge;
            String modName = Mods.IS_WAILA_LOADED ? " (" + SpecialChars.BLUE + SpecialChars.ITALIC + ModIdentification.nameFromStack((ItemStack)wrenchStack) + SpecialChars.RESET + SpecialChars.GRAY + ")" : "";
            list.add(wrenchStack.func_82833_r() + modName);
            wrenchStack.func_77973_b().func_77624_a(wrenchStack, entityPlayer, list, flag);
            if (Mods.IS_IC2_LOADED && (charge = ElectricItem.manager.getToolTip(wrenchStack)) != null) {
                list.add(charge);
            }
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            String[] tooltipLines;
            for (String s : tooltipLines = StatCollector.func_74838_a((String)Strings.TOOLBOX_INFO).split("\\\\n")) {
                list.add("\u00a73" + s);
            }
        } else {
            list.add("\u00a76" + StatCollector.func_74838_a((String)Strings.TOOLTIP_SHIFT));
        }
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        ItemStack copiedStack = itemStack.func_77946_l();
        if (copiedStack.func_77942_o()) {
            NBTTagList list = copiedStack.func_77978_p().func_150295_c("wrenches", 10);
            int index = copiedStack.func_77978_p().func_74771_c("index");
            if (index < list.func_74745_c()) {
                list.func_74744_a(index);
                if (--index < 0) {
                    index = 0;
                }
                copiedStack.func_77978_p().func_74774_a("index", (byte)index);
            }
        }
        return copiedStack;
    }

    public int getDamage(ItemStack stack) {
        ItemStack wrenchStack = this.getCurrentWrench(stack);
        return wrenchStack == null ? super.getDamage(stack) : wrenchStack.func_77973_b().getDamage(wrenchStack);
    }

    public int getDisplayDamage(ItemStack stack) {
        ItemStack wrenchStack = this.getCurrentWrench(stack);
        return wrenchStack == null ? super.getDisplayDamage(stack) : wrenchStack.func_77973_b().getDisplayDamage(wrenchStack);
    }

    public int getMaxDamage(ItemStack stack) {
        ItemStack wrenchStack = this.getCurrentWrench(stack);
        return wrenchStack == null ? super.getMaxDamage(stack) : wrenchStack.func_77973_b().getMaxDamage(wrenchStack);
    }

    public boolean isDamaged(ItemStack stack) {
        ItemStack wrenchStack = this.getCurrentWrench(stack);
        return wrenchStack == null ? super.isDamaged(stack) : wrenchStack.func_77973_b().isDamaged(wrenchStack);
    }

    public void setDamage(ItemStack stack, int damage) {
        ItemStack wrenchStack = this.getCurrentWrench(stack);
        if (wrenchStack != null) {
            wrenchStack.func_77973_b().setDamage(wrenchStack, damage);
        }
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        return this.field_77791_bV;
    }

    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a(Resources.MOD_ID + ":" + "toolbox");
    }
}

