/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.network.packet;

import com.dynious.refinedrelocation.grid.relocator.TravellingItem;
import com.dynious.refinedrelocation.helper.DirectionHelper;
import com.dynious.refinedrelocation.network.NetworkHandler;
import com.dynious.refinedrelocation.network.packet.MessageItemRequest;
import com.dynious.refinedrelocation.tileentity.IRelocator;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class MessageItemList
implements IMessage,
IMessageHandler<MessageItemList, IMessage> {
    private int x;
    private int y;
    private int z;
    private List<TravellingItem> items;
    private List<IdAndPosition> idAndPos;

    public MessageItemList() {
    }

    public MessageItemList(TileEntity tile, List<TravellingItem> items) {
        this.x = tile.field_145851_c;
        this.y = tile.field_145848_d;
        this.z = tile.field_145849_e;
        this.items = items;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.items = new ArrayList<TravellingItem>();
        this.idAndPos = new ArrayList<IdAndPosition>();
        int size = buf.readByte();
        for (int i = 0; i < size; ++i) {
            byte id = buf.readByte();
            byte outAndIn = buf.readByte();
            boolean idChange = (outAndIn >> 7 & 1) == 1;
            boolean sync = (outAndIn >> 6 & 1) == 1;
            ArrayList<Byte> list = new ArrayList<Byte>();
            list.add((byte)(outAndIn >> 3 & 7));
            byte input = (byte)(outAndIn & 7);
            if (input == 7) {
                input = -1;
            }
            if (sync) {
                this.items.add(new TravellingItem(ByteBufUtils.readItemStack((ByteBuf)buf), list, input, id));
                continue;
            }
            if (idChange) {
                this.idAndPos.add(new IdAndPosition(id, list, input, buf.readByte()));
            }
            this.idAndPos.add(new IdAndPosition(id, list, input));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeByte(this.items.size());
        for (TravellingItem item : this.items) {
            buf.writeByte((int)item.id);
            buf.writeByte((int)((byte)((byte)((item.lastId != null ? 1 : 0) << 7) | (byte)((item.sync ? 1 : 0) << 6) | (byte)(item.getOutputSide() << 3) | (item.getInputSide() == -1 ? 7 : (int)item.getInputSide()))));
            if (item.sync) {
                ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)item.getItemStack());
            }
            if (item.lastId == null) continue;
            buf.writeByte((int)item.lastId.byteValue());
        }
    }

    public IMessage onMessage(MessageItemList message, MessageContext ctx) {
        TileEntity tile = FMLClientHandler.instance().getClient().field_71441_e.func_147438_o(message.x, message.y, message.z);
        if (tile != null) {
            for (TravellingItem item : message.items) {
                ((IRelocator)tile).receiveTravellingItem(item);
            }
            for (IdAndPosition idAndPosition : message.idAndPos) {
                TileEntity te = DirectionHelper.getTileAtSide(tile, ForgeDirection.getOrientation((int)idAndPosition.input));
                if (te instanceof IRelocator) {
                    ItemStack stack = ((IRelocator)te).getItemStackWithId(idAndPosition.oldId == null ? idAndPosition.id : idAndPosition.oldId);
                    ((IRelocator)tile).receiveTravellingItem(new TravellingItem(stack, idAndPosition.list, idAndPosition.input, idAndPosition.id));
                    if (stack != null) continue;
                    NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageItemRequest(tile, idAndPosition.id));
                    continue;
                }
                ((IRelocator)tile).receiveTravellingItem(new TravellingItem(null, idAndPosition.list, idAndPosition.input, idAndPosition.id));
                NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageItemRequest(tile, idAndPosition.id));
            }
        }
        return null;
    }

    private static class IdAndPosition {
        public byte id;
        public byte input;
        public List<Byte> list;
        public Byte oldId;

        public IdAndPosition(byte id, List<Byte> list, byte input) {
            this.id = id;
            this.list = list;
            this.input = input;
        }

        public IdAndPosition(byte id, List<Byte> list, byte input, byte oldId) {
            this.id = id;
            this.list = list;
            this.input = input;
            this.oldId = oldId;
        }
    }
}

