/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.repack.codechicken.lib.config;

import com.dynious.refinedrelocation.repack.codechicken.lib.config.ConfigFile;
import com.dynious.refinedrelocation.repack.codechicken.lib.config.ConfigTagParent;
import java.io.PrintWriter;

public class ConfigTag
extends ConfigTagParent {
    public ConfigTagParent parent;
    public String name;
    public String qualifiedname;
    public String value;
    public boolean brace;
    public boolean newline;
    public int position = Integer.MAX_VALUE;
    private int IDBase;

    public ConfigTag(ConfigTagParent parent, String name) {
        this.parent = parent;
        this.name = name;
        this.qualifiedname = parent.getNameQualifier() + name;
        this.newline = parent.newlinemode == 2;
        parent.addChild(this);
    }

    @Override
    public String getNameQualifier() {
        return this.qualifiedname + ".";
    }

    @Override
    public void saveConfig() {
        this.parent.saveConfig();
    }

    public ConfigTag onLoaded() {
        return this;
    }

    public void setValue(String value) {
        this.value = value;
        this.saveConfig();
    }

    public void setDefaultValue(String defaultValue) {
        if (this.value == null) {
            this.value = defaultValue;
            this.saveConfig();
        }
    }

    public void setIntValue(int i) {
        this.setValue(Integer.toString(i));
    }

    public void setBooleanValue(boolean b) {
        this.setValue(Boolean.toString(b));
    }

    public void setHexValue(int i) {
        this.setValue("0x" + Long.toString((long)i << 32 >>> 32, 16));
    }

    public <T> void set(IConfigType<T> type, T entry) {
        this.setValue(type.configValue(entry));
    }

    public String getValue() {
        return this.value;
    }

    public String getValue(String defaultValue) {
        this.setDefaultValue(defaultValue);
        return this.value;
    }

    public int getIntValue() {
        return Integer.parseInt(this.getValue());
    }

    public int getIntValue(int defaultValue) {
        try {
            if (this.value != null) {
                return this.getIntValue();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.setIntValue(defaultValue);
        return defaultValue;
    }

    public boolean getBooleanValue() {
        String value = this.getValue();
        if (value != null && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes"))) {
            return true;
        }
        if (value != null && (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("no"))) {
            return false;
        }
        throw new NumberFormatException(this.qualifiedname + ".value=" + value);
    }

    public boolean getBooleanValue(boolean defaultValue) {
        try {
            if (this.value != null) {
                return this.getBooleanValue();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.setBooleanValue(defaultValue);
        return defaultValue;
    }

    public int getHexValue() {
        return (int)Long.parseLong(this.getValue().replace("0x", ""), 16);
    }

    public int getHexValue(int defaultValue) {
        try {
            if (this.value != null) {
                return this.getHexValue();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.setHexValue(defaultValue);
        return defaultValue;
    }

    public <T> T get(IConfigType<T> type) {
        try {
            return type.valueOf(this.getValue());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T get(IConfigType<T> type, T defaultValue) {
        try {
            if (this.value != null) {
                return this.get(type);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.set(type, defaultValue);
        return defaultValue;
    }

    public void save(PrintWriter writer, int tabs, String bracequalifier, boolean first) {
        String vname = this.qualifiedname.contains(".") && bracequalifier.length() > 0 ? this.qualifiedname.substring(bracequalifier.length() + 1) : this.qualifiedname;
        if (this.newline && !first) {
            ConfigFile.writeLine(writer, "", tabs);
        }
        this.writeComment(writer, tabs);
        if (this.value != null) {
            ConfigFile.writeLine(writer, vname + "=" + this.value, tabs);
        }
        if (!this.hasChildTags()) {
            return;
        }
        if (this.brace) {
            if (this.value == null) {
                ConfigFile.writeLine(writer, vname, tabs);
            }
            ConfigFile.writeLine(writer, "{", tabs);
            this.saveTagTree(writer, tabs + 1, this.qualifiedname);
            ConfigFile.writeLine(writer, "}", tabs);
        } else {
            this.saveTagTree(writer, tabs, bracequalifier);
        }
    }

    @Override
    public ConfigTag setComment(String comment) {
        super.setComment(comment);
        return this;
    }

    @Override
    public ConfigTag setSortMode(int mode) {
        super.setSortMode(mode);
        return this;
    }

    public ConfigTag setNewLine(boolean b) {
        this.newline = b;
        this.saveConfig();
        return this;
    }

    public ConfigTag useBraces() {
        this.brace = true;
        if (this.parent.newlinemode == 1) {
            this.newline = true;
        }
        this.saveConfig();
        return this;
    }

    public ConfigTag setPosition(int pos) {
        this.position = pos;
        this.saveConfig();
        return this;
    }

    @Override
    public boolean containsTag(String tagname) {
        return this.getTag(tagname, false) != null;
    }

    public int getId(String name, int defaultValue) {
        return this.getTag(name).getIntValue(defaultValue);
    }

    public int getId(String name) {
        int ret = this.getId(name, this.IDBase);
        this.IDBase = ret + 1;
        return ret;
    }

    public int getAcheivementId(String name, int defaultValue) {
        return this.getTag(name).getIntValue(defaultValue);
    }

    public ConfigTag setBaseID(int i) {
        this.IDBase = i;
        return this;
    }

    public static interface IConfigType<T> {
        public String configValue(T var1);

        public T valueOf(String var1) throws Exception;
    }
}

