/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.tileentity;

import com.dynious.refinedrelocation.api.APIUtils;
import com.dynious.refinedrelocation.api.filter.IFilterGUI;
import com.dynious.refinedrelocation.helper.ItemStackHelper;
import com.dynious.refinedrelocation.tileentity.IAdvancedFilteredTile;
import com.dynious.refinedrelocation.tileentity.TileBlockExtender;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileAdvancedFilteredBlockExtender
extends TileBlockExtender
implements IAdvancedFilteredTile {
    public boolean restrictExtraction = false;
    private boolean spreadItems = false;
    private byte[] insertDirection = new byte[]{1, 1, 1, 1, 1, 1, 1};
    private int bestSlot;
    private boolean shouldUpdateBestSlot = true;
    private int lastSlotSide;
    private ItemStack lastStack;
    private IFilterGUI filter = APIUtils.createStandardFilter(this);
    private byte maxStackSize = (byte)64;

    @Override
    public boolean getRestrictExtraction() {
        return this.restrictExtraction;
    }

    @Override
    public void setRestrictionExtraction(boolean restrict) {
        this.restrictExtraction = restrict;
        this.func_70296_d();
    }

    @Override
    public byte[] getInsertDirection() {
        return this.insertDirection;
    }

    @Override
    public void setInsertDirection(int from, int value) {
        int numDirs = ForgeDirection.VALID_DIRECTIONS.length;
        value = (value % numDirs + numDirs) % numDirs;
        this.insertDirection[from] = (byte)value;
        this.func_70296_d();
    }

    @Override
    public void setConnectedSide(int connectedSide) {
        ForgeDirection lastConnectedDirection = this.connectedDirection;
        super.setConnectedSide(connectedSide);
        if (this.connectedDirection != ForgeDirection.UNKNOWN && lastConnectedDirection != this.connectedDirection) {
            for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
                this.insertDirection[i] = (byte)this.connectedDirection.getOpposite().ordinal();
            }
        }
    }

    @Override
    public boolean func_102007_a(int i, ItemStack itemStack, int i2) {
        if (this.spreadItems) {
            if (this.shouldUpdateBestSlot || this.lastSlotSide != i2 || !ItemStackHelper.areItemStacksEqual(itemStack, this.lastStack)) {
                this.updateBestSlot(i2, itemStack);
                this.shouldUpdateBestSlot = false;
            }
            if (i != this.bestSlot || !super.func_102007_a(this.bestSlot, itemStack, i2)) {
                return false;
            }
            this.shouldUpdateBestSlot = true;
            return this.filter.passesFilter(itemStack);
        }
        return super.func_102007_a(i, itemStack, i2) && this.filter.passesFilter(itemStack);
    }

    private void updateBestSlot(int side, ItemStack itemStack) {
        int[] invAccessibleSlots;
        int bestSize = Integer.MAX_VALUE;
        for (int slot : invAccessibleSlots = this.func_94128_d(side)) {
            ItemStack stack = this.func_70301_a(slot);
            if (!super.func_102007_a(slot, itemStack, side)) continue;
            if (stack == null) {
                this.bestSlot = slot;
                break;
            }
            if (!ItemStackHelper.areItemStacksEqual(itemStack, stack) || stack.field_77994_a >= bestSize) continue;
            this.bestSlot = slot;
            bestSize = stack.field_77994_a;
        }
        this.lastSlotSide = side;
        this.lastStack = itemStack;
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int i2) {
        return super.func_102008_b(i, itemStack, i2) && (!this.restrictExtraction || !this.filter.passesFilter(itemStack));
    }

    @Override
    public byte getMaxStackSize() {
        return this.maxStackSize;
    }

    @Override
    public void setMaxStackSize(byte maxStackSize) {
        this.maxStackSize = maxStackSize;
        this.func_70296_d();
    }

    @Override
    public boolean getSpreadItems() {
        return this.spreadItems;
    }

    @Override
    public void setSpreadItems(boolean spreadItems) {
        this.spreadItems = spreadItems;
        this.func_70296_d();
    }

    @Override
    public int func_70297_j_() {
        if (this.getInventory() != null) {
            return Math.min(super.func_70297_j_(), this.maxStackSize);
        }
        return this.maxStackSize;
    }

    @Override
    public ForgeDirection getInputSide(ForgeDirection side) {
        return ForgeDirection.getOrientation((int)this.insertDirection[side.ordinal()]);
    }

    @Override
    public IFilterGUI getFilter() {
        return this.filter;
    }

    @Override
    public TileEntity getTileEntity() {
        return this;
    }

    @Override
    public void onFilterChanged() {
        this.func_70296_d();
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.restrictExtraction = compound.func_74767_n("restrictExtraction");
        this.spreadItems = compound.func_74767_n("spreadItems");
        this.insertDirection = compound.func_74770_j("insertDirection");
        this.maxStackSize = compound.func_74771_c("maxStackSize");
        this.filter.readFromNBT(compound);
    }

    @Override
    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74757_a("restrictExtraction", this.restrictExtraction);
        compound.func_74757_a("spreadItems", this.spreadItems);
        compound.func_74773_a("insertDirection", this.insertDirection);
        compound.func_74774_a("maxStackSize", this.maxStackSize);
        this.filter.writeToNBT(compound);
    }
}

