/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.tileentity;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridNotification;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.ICellContainer;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import appeng.core.sync.GuiBridge;
import appeng.helpers.IPriorityHost;
import appeng.util.Platform;
import com.dynious.refinedrelocation.api.tileentity.IInventoryChangeListener;
import com.dynious.refinedrelocation.api.tileentity.grid.LocalizedStack;
import com.dynious.refinedrelocation.block.ModBlocks;
import com.dynious.refinedrelocation.helper.ItemStackHelper;
import com.dynious.refinedrelocation.tileentity.TileSortingConnector;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileMESortingInterface
extends TileSortingConnector
implements ICellContainer,
IGridBlock,
IInventoryChangeListener,
IPriorityHost {
    private IGridNode node = null;
    private IMEInventoryHandler<IAEItemStack> handler;
    private BaseActionSource mySrc = new MachineSource((IActionHost)this);
    private NBTTagCompound data;
    private boolean isReady = false;
    private boolean wasActive = false;
    private boolean shouldUpdateStorage = true;
    private IItemList<IAEItemStack> cachedItemList = AEApi.instance().storage().createItemList();
    private int priority = 0;
    private EntityPlayer owner;

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (!this.isReady) {
                this.isReady = true;
                this.getGridNode(null).getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
            }
            if (this.node.isActive() && this.shouldUpdateStorage) {
                this.shouldUpdateStorage = false;
                this.updateStorage();
            }
        }
    }

    @Override
    public boolean onActivated(EntityPlayer player, int side) {
        if (!this.field_145850_b.field_72995_K) {
            Platform.openGUI((EntityPlayer)player, (TileEntity)this, (ForgeDirection)ForgeDirection.getOrientation((int)side), (GuiBridge)GuiBridge.GUI_PRIORITY);
            return true;
        }
        return false;
    }

    private void updateStorage() {
        List<LocalizedStack> currentStacks = this.getHandler().getGrid().getItemsInGrid();
        IItemList tempItemList = AEApi.instance().storage().createItemList();
        for (Object stack : this.cachedItemList) {
            tempItemList.add((IAEStack)stack.copy());
        }
        Iterator iterator = tempItemList.iterator();
        block1: while (iterator.hasNext()) {
            Object stack;
            stack = (IAEItemStack)iterator.next();
            Iterator<LocalizedStack> iterator1 = currentStacks.iterator();
            while (iterator1.hasNext()) {
                LocalizedStack newStack = iterator1.next();
                if (!stack.equals(newStack.STACK)) continue;
                iterator1.remove();
                stack.setStackSize(stack.getStackSize() - (long)newStack.getStackSize());
                if (stack.getStackSize() != 0L) continue;
                iterator.remove();
                continue block1;
            }
        }
        IStorageGrid storage = (IStorageGrid)this.getGridNode(null).getGrid().getCache(IStorageGrid.class);
        for (IAEItemStack stack : tempItemList) {
            stack.setStackSize(-stack.getStackSize());
            if (stack.getStackSize() < 0L) {
                this.removeStackFromCache(stack.copy());
                continue;
            }
            this.cachedItemList.add((IAEStack)stack);
        }
        storage.postAlterationOfStoredItems(StorageChannel.ITEMS, (Iterable)tempItemList, this.mySrc);
        IItemList list = AEApi.instance().storage().createItemList();
        for (LocalizedStack stack : currentStacks) {
            IAEItemStack aeStack = AEApi.instance().storage().createItemStack(stack.STACK);
            list.add((IAEStack)aeStack);
            this.cachedItemList.add((IAEStack)aeStack);
        }
        storage.postAlterationOfStoredItems(StorageChannel.ITEMS, (Iterable)list, this.mySrc);
    }

    private void removeStackFromCache(IAEItemStack stack) {
        for (IAEItemStack stack1 : this.cachedItemList) {
            if (!stack1.equals(stack)) continue;
            long amount = Math.min(stack1.getStackSize(), -stack.getStackSize());
            stack1.setStackSize(stack1.getStackSize() - amount);
            stack.setStackSize(stack.getStackSize() + amount);
            if (stack.getStackSize() != 0L) continue;
            return;
        }
    }

    public IMEInventoryHandler<IAEItemStack> getInternalHandler() {
        if (this.handler == null) {
            this.handler = new SortingInventoryHandler(this);
        }
        return this.handler;
    }

    public IAEItemStack injectItems(IAEItemStack aeItemStack, Actionable actionable, BaseActionSource baseActionSource) {
        IAEItemStack aeItemStack1 = aeItemStack.copy();
        ItemStack stack = aeItemStack1.getItemStack();
        ItemStack returnedStack = null;
        while (aeItemStack1.getStackSize() > 0L && returnedStack == null) {
            int amount;
            stack.field_77994_a = amount = (int)Math.min(64L, aeItemStack1.getStackSize());
            returnedStack = this.getHandler().getGrid().filterStackToGroup(stack, this, 0, actionable != Actionable.MODULATE);
            if (returnedStack != null) {
                amount -= returnedStack.field_77994_a;
            }
            aeItemStack1.setStackSize(aeItemStack1.getStackSize() - (long)amount);
        }
        if (aeItemStack1.getStackSize() == 0L) {
            return null;
        }
        return aeItemStack1;
    }

    public IAEItemStack extractItems(IAEItemStack aeItemStack, Actionable actionable, BaseActionSource baseActionSource) {
        ItemStack stackToExtract = aeItemStack.getItemStack();
        int extracted = 0;
        IStorageGrid storage = (IStorageGrid)this.getGridNode(null).getGrid().getCache(IStorageGrid.class);
        IItemList list = AEApi.instance().storage().createItemList();
        for (LocalizedStack stack : this.getHandler().getGrid().getItemsInGrid()) {
            if (!ItemStackHelper.areItemStacksEqual(stack.STACK, stackToExtract)) continue;
            int amount = Math.min(stack.getStackSize(), stackToExtract.field_77994_a - extracted);
            extracted += amount;
            if (actionable == Actionable.MODULATE) {
                IAEItemStack aeStack = AEApi.instance().storage().createItemStack(stack.STACK);
                aeStack.setStackSize((long)(-amount));
                this.removeStackFromCache(aeStack.copy());
                stack.alterStackSize(-amount);
                if (stack.getStackSize() == 0) {
                    stack.INVENTORY.func_70299_a(stack.SLOT, null);
                }
            }
            if (extracted < stackToExtract.field_77994_a) continue;
            if (actionable == Actionable.MODULATE) {
                IAEItemStack removedStack = aeItemStack.copy();
                removedStack.setStackSize((long)(-extracted));
                list.add((IAEStack)removedStack);
                storage.postAlterationOfStoredItems(StorageChannel.ITEMS, (Iterable)list, this.mySrc);
            }
            return aeItemStack;
        }
        if (extracted == 0) {
            return null;
        }
        IAEItemStack removedStack = aeItemStack.copy();
        removedStack.setStackSize((long)(-extracted));
        list.add((IAEStack)removedStack);
        storage.postAlterationOfStoredItems(StorageChannel.ITEMS, (Iterable)list, this.mySrc);
        IAEItemStack aeItemStack1 = aeItemStack.copy();
        aeItemStack1.setStackSize((long)extracted);
        return aeItemStack1;
    }

    public IItemList<IAEItemStack> getAvailableItems(IItemList<IAEItemStack> aeItemStacks) {
        for (IAEItemStack cachedStack : this.cachedItemList) {
            aeItemStacks.add((IAEStack)cachedStack);
        }
        return aeItemStacks;
    }

    public StorageChannel getChannel() {
        return StorageChannel.ITEMS;
    }

    public IGridNode getGridNode(ForgeDirection direction) {
        if (this.node == null && !this.field_145850_b.field_72995_K && this.isReady) {
            this.node = AEApi.instance().createGridNode((IGridBlock)this);
            if (this.data != null) {
                this.node.loadFromNBT("node", this.data);
            } else if (this.owner != null) {
                this.node.setPlayerID(AEApi.instance().registries().players().getID(this.owner));
                this.owner = null;
            }
            this.node.updateState();
        }
        return this.node;
    }

    public AECableType getCableConnectionType(ForgeDirection direction) {
        return AECableType.COVERED;
    }

    public void securityBreak() {
        this.field_145850_b.func_147480_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, true);
    }

    public double getIdlePowerUsage() {
        return 0.0;
    }

    public EnumSet<GridFlags> getFlags() {
        return EnumSet.of(GridFlags.REQUIRE_CHANNEL);
    }

    public boolean isWorldAccessable() {
        return true;
    }

    public boolean isWorldAccessible() {
        return true;
    }

    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    public AEColor getGridColor() {
        return AEColor.Transparent;
    }

    public void onGridNotification(GridNotification gridNotification) {
    }

    public void setNetworkStatus(IGrid iGrid, int i) {
    }

    public EnumSet<ForgeDirection> getConnectableSides() {
        return EnumSet.allOf(ForgeDirection.class);
    }

    public IGridHost getMachine() {
        return this;
    }

    public void gridChanged() {
    }

    public ItemStack getMachineRepresentation() {
        return new ItemStack((Block)ModBlocks.sortingConnector, 1, 3);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.priority = compound.func_74762_e("priority");
        this.data = compound;
    }

    @Override
    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74768_a("priority", this.priority);
        if (this.node != null) {
            this.node.saveToNBT("node", compound);
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.isReady = false;
        if (this.node != null) {
            this.node.destroy();
            this.node = null;
        }
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        this.isReady = false;
        if (this.node != null) {
            this.node.destroy();
            this.node = null;
        }
    }

    public List<IMEInventoryHandler> getCellArray(StorageChannel storageChannel) {
        if (storageChannel == StorageChannel.ITEMS) {
            return Arrays.asList(this.getInternalHandler());
        }
        return Collections.emptyList();
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void blinkCell(int i) {
    }

    public IGridNode getActionableNode() {
        return this.node;
    }

    @Override
    public void onInventoryChanged() {
        this.shouldUpdateStorage = true;
    }

    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.updateStatus();
    }

    @MENetworkEventSubscribe
    public void updateChannels(MENetworkChannelsChanged chann) {
        this.updateStatus();
    }

    private void updateStatus() {
        if (this.node.isActive() != this.wasActive) {
            this.wasActive = this.node.isActive();
            this.getGridNode(null).getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
        }
    }

    public void saveChanges(IMEInventory imeInventory) {
        this.field_145850_b.func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
    }

    public void setOwner(EntityPlayer player) {
        this.owner = player;
    }

    private static class SortingInventoryHandler
    implements IMEInventoryHandler<IAEItemStack> {
        private TileMESortingInterface tile;

        private SortingInventoryHandler(TileMESortingInterface tile) {
            this.tile = tile;
        }

        public AccessRestriction getAccess() {
            return AccessRestriction.READ_WRITE;
        }

        public boolean isPrioritized(IAEItemStack iaeStack) {
            return true;
        }

        public boolean canAccept(IAEItemStack iaeStack) {
            return true;
        }

        public int getPriority() {
            return this.tile.getPriority();
        }

        public int getSlot() {
            return 0;
        }

        public boolean validForPass(int i) {
            return true;
        }

        public IAEItemStack injectItems(IAEItemStack iaeStack, Actionable actionable, BaseActionSource baseActionSource) {
            return this.tile.injectItems(iaeStack, actionable, baseActionSource);
        }

        public IAEItemStack extractItems(IAEItemStack iaeStack, Actionable actionable, BaseActionSource baseActionSource) {
            return this.tile.extractItems(iaeStack, actionable, baseActionSource);
        }

        public IItemList<IAEItemStack> getAvailableItems(IItemList<IAEItemStack> iItemList) {
            return this.tile.getAvailableItems(iItemList);
        }

        public StorageChannel getChannel() {
            return this.tile.getChannel();
        }
    }
}

