/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.tileentity;

import cofh.api.energy.IEnergyHandler;
import com.dynious.refinedrelocation.compat.IC2Helper;
import com.dynious.refinedrelocation.helper.DirectionHelper;
import com.dynious.refinedrelocation.helper.EnergyType;
import com.dynious.refinedrelocation.helper.LoopHelper;
import com.dynious.refinedrelocation.lib.Mods;
import com.dynious.refinedrelocation.tileentity.ILoopable;
import cpw.mods.fml.common.Optional;
import ic2.api.energy.tile.IEnergySink;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="IC2"), @Optional.Interface(iface="cofh.api.energy.IEnergyHandler", modid="CoFHAPI|energy")})
public class TilePowerLimiter
extends TileEntity
implements ILoopable,
IEnergyHandler,
IEnergySink {
    public boolean blocksChanged = true;
    protected ForgeDirection connectedDirection = ForgeDirection.UNKNOWN;
    protected ForgeDirection previousConnectedDirection = ForgeDirection.UNKNOWN;
    protected IEnergySink energySink;
    protected IEnergyHandler energyHandler;
    private double maxAcceptedEnergy = 10.0;
    private boolean disablePower = false;
    private boolean redstoneToggle = false;
    private boolean oldState = false;

    public void setConnectedSide(int connectedSide) {
        this.connectedDirection = ForgeDirection.getOrientation((int)connectedSide);
        this.blocksChanged = true;
        if (this.field_145850_b != null) {
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        }
    }

    public ForgeDirection getConnectedDirection() {
        return this.connectedDirection;
    }

    public IEnergySink getEnergySink() {
        return this.energySink;
    }

    public void setEnergySink(IEnergySink energySink) {
        if (this.energySink == null && energySink != null) {
            this.energySink = energySink;
            if (!this.field_145850_b.field_72995_K) {
                IC2Helper.addToEnergyNet(this);
            }
        } else if (this.energySink != null) {
            if (energySink == null && !this.field_145850_b.field_72995_K) {
                IC2Helper.removeFromEnergyNet(this);
            }
            this.energySink = energySink;
        }
    }

    public IEnergyHandler getEnergyHandler() {
        return this.energyHandler;
    }

    public void setEnergyHandler(IEnergyHandler energyHandler) {
        this.energyHandler = energyHandler;
    }

    public double getMaxAcceptedEnergy() {
        return this.maxAcceptedEnergy;
    }

    public void setMaxAcceptedEnergy(double value) {
        this.maxAcceptedEnergy = value;
    }

    public boolean getDisablePower() {
        return this.disablePower;
    }

    public void setDisablePower(boolean value) {
        if (value != this.disablePower) {
            this.disablePower = value;
            if (this.field_145850_b != null) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    public boolean getRedstoneToggle() {
        return this.redstoneToggle;
    }

    public void setRedstoneToggle(boolean toggle) {
        this.redstoneToggle = toggle;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.newRedstoneState(this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        }
    }

    public void newRedstoneState(boolean state) {
        if (this.redstoneToggle) {
            if (!this.oldState && state) {
                this.setDisablePower(!this.disablePower);
            }
            this.oldState = state;
        } else {
            this.setDisablePower(state);
        }
    }

    public void func_145843_s() {
        if (this.getEnergySink() != null && !this.field_145850_b.field_72995_K) {
            IC2Helper.removeFromEnergyNet(this);
        }
        super.func_145843_s();
    }

    public void onChunkUnload() {
        if (this.getEnergySink() != null && !this.field_145850_b.field_72995_K) {
            IC2Helper.removeFromEnergyNet(this);
        }
        super.onChunkUnload();
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.canConnect()) {
            TileEntity tile = null;
            if (this.connectedDirection != this.previousConnectedDirection) {
                tile = this.getConnectedTile();
                this.resetConnections();
                this.checkConnectedDirection(tile);
                this.previousConnectedDirection = this.connectedDirection;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            if (this.blocksChanged) {
                if (tile == null) {
                    tile = this.getConnectedTile();
                }
                if (tile == null) {
                    this.resetConnections();
                    this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
                } else {
                    this.checkConnectedDirection(tile);
                }
                if (!this.field_145850_b.field_72995_K) {
                    this.newRedstoneState(this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e));
                }
                this.blocksChanged = false;
            }
        }
    }

    protected void checkConnectedDirection(TileEntity tile) {
        if (tile != null && !LoopHelper.isLooping(this, tile)) {
            boolean updated = false;
            if (Mods.IS_IC2_LOADED && tile instanceof IEnergySink) {
                if (this.getEnergySink() == null) {
                    updated = true;
                }
                this.setEnergySink((IEnergySink)tile);
            }
            if (Mods.IS_COFH_ENERGY_API_LOADED && tile instanceof IEnergyHandler) {
                if (this.getEnergyHandler() == null) {
                    updated = true;
                }
                this.setEnergyHandler((IEnergyHandler)tile);
            }
            if (updated) {
                this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
            }
        }
    }

    protected void resetConnections() {
        this.setEnergySink(null);
        this.setEnergyHandler(null);
    }

    public List<EnergyType> getConnectionTypes() {
        ArrayList<EnergyType> connections = new ArrayList<EnergyType>();
        if (Mods.IS_IC2_LOADED && this.getEnergySink() != null) {
            connections.add(EnergyType.EU);
        }
        if (Mods.IS_COFH_ENERGY_API_LOADED && this.getEnergyHandler() != null) {
            connections.add(EnergyType.RF);
        }
        return connections;
    }

    public boolean canConnect() {
        return this.connectedDirection != ForgeDirection.UNKNOWN;
    }

    public TileEntity getConnectedTile() {
        return DirectionHelper.getTileAtSide(this, this.connectedDirection);
    }

    @Override
    public List<TileEntity> getConnectedTiles() {
        return Arrays.asList(DirectionHelper.getTileAtSide(this, this.connectedDirection));
    }

    @Optional.Method(modid="IC2")
    public double getDemandedEnergy() {
        if (this.getEnergySink() != null && !this.getDisablePower()) {
            double demanded = this.getEnergySink().getDemandedEnergy();
            if (demanded > EnergyType.EU.fromInternal(this.maxAcceptedEnergy)) {
                demanded = EnergyType.EU.fromInternal(this.maxAcceptedEnergy);
            }
            return demanded;
        }
        return 0.0;
    }

    @Optional.Method(modid="IC2")
    public double injectEnergy(ForgeDirection forgeDirection, double v, double v2) {
        if (this.getEnergySink() != null && !this.getDisablePower()) {
            double storedEnergy = 0.0;
            if (v > EnergyType.EU.fromInternal(this.maxAcceptedEnergy)) {
                storedEnergy = v - EnergyType.EU.fromInternal(this.maxAcceptedEnergy);
                v = EnergyType.EU.fromInternal(this.maxAcceptedEnergy);
            }
            return this.getEnergySink().injectEnergy(this.connectedDirection.getOpposite(), v, v2) + storedEnergy;
        }
        return v;
    }

    @Optional.Method(modid="IC2")
    public int getSinkTier() {
        if (this.getEnergySink() != null) {
            return this.getEnergySink().getSinkTier();
        }
        return 0;
    }

    @Optional.Method(modid="IC2")
    public boolean acceptsEnergyFrom(TileEntity tileEntity, ForgeDirection forgeDirection) {
        return this.getEnergySink() != null && this.getEnergySink().acceptsEnergyFrom(tileEntity, this.connectedDirection.getOpposite());
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int receiveEnergy(ForgeDirection forgeDirection, int i, boolean b) {
        if (this.getEnergyHandler() != null && !this.getDisablePower()) {
            if ((double)i > EnergyType.RF.fromInternal(this.maxAcceptedEnergy)) {
                i = (int)EnergyType.RF.fromInternal(this.maxAcceptedEnergy);
            }
            return this.getEnergyHandler().receiveEnergy(this.connectedDirection.getOpposite(), i, b);
        }
        return 0;
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int extractEnergy(ForgeDirection forgeDirection, int i, boolean b) {
        if (this.getEnergyHandler() != null) {
            return this.getEnergyHandler().extractEnergy(this.connectedDirection.getOpposite(), i, b);
        }
        return 0;
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public boolean canConnectEnergy(ForgeDirection forgeDirection) {
        return this.getEnergyHandler() != null && this.getEnergyHandler().canConnectEnergy(this.connectedDirection.getOpposite());
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int getEnergyStored(ForgeDirection forgeDirection) {
        if (this.getEnergyHandler() != null) {
            return this.getEnergyHandler().getEnergyStored(this.connectedDirection.getOpposite());
        }
        return 0;
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int getMaxEnergyStored(ForgeDirection forgeDirection) {
        if (this.getEnergyHandler() != null) {
            return this.getEnergyHandler().getMaxEnergyStored(this.connectedDirection.getOpposite());
        }
        return 0;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.setConnectedSide(compound.func_74771_c("side"));
        this.setMaxAcceptedEnergy(compound.func_74769_h("maxEnergy"));
        this.setDisablePower(compound.func_74767_n("disablePower"));
        this.setRedstoneToggle(compound.func_74767_n("toggle"));
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74774_a("side", (byte)this.connectedDirection.ordinal());
        compound.func_74780_a("maxEnergy", this.maxAcceptedEnergy);
        compound.func_74757_a("disablePower", this.getDisablePower());
        compound.func_74757_a("toggle", this.getRedstoneToggle());
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.setConnectedSide(pkt.func_148857_g().func_74771_c("side"));
        this.setDisablePower(pkt.func_148857_g().func_74767_n("disablePower"));
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74774_a("side", (byte)this.connectedDirection.ordinal());
        compound.func_74757_a("disablePower", this.getDisablePower());
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, compound);
    }

    public boolean rotateBlock() {
        this.setConnectedSide((this.getConnectedDirection().ordinal() + 1) % ForgeDirection.VALID_DIRECTIONS.length);
        return true;
    }
}

