/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.tileentity;

import com.dynious.refinedrelocation.RefinedRelocation;
import com.dynious.refinedrelocation.block.ModBlocks;
import com.dynious.refinedrelocation.helper.LogHelper;
import com.dynious.refinedrelocation.helper.TeleportHelper;
import com.dynious.refinedrelocation.util.Vector3;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.ForgeChunkManager;

public class TileRelocationPortal
extends TileEntity {
    public Block oldBlock = Blocks.field_150350_a;
    public int oldMeta = 0;
    private Vector3 linkedPos;
    private int dimension = Integer.MAX_VALUE;
    private byte time = 0;

    public void init(Block oldBlock, int oldMeta) {
        this.oldBlock = oldBlock;
        this.oldMeta = oldMeta;
    }

    public void init(Block oldBlock, int oldMeta, Vector3 linkedPos) {
        this.oldBlock = oldBlock;
        this.oldMeta = oldMeta;
        this.linkedPos = linkedPos;
    }

    public void init(Block oldBlock, int oldMeta, Vector3 linkedPos, int dimension) {
        WorldServer linkedWorld;
        this.oldBlock = oldBlock;
        this.oldMeta = oldMeta;
        this.linkedPos = linkedPos;
        this.dimension = dimension;
        if (FMLCommonHandler.instance().getEffectiveSide().isServer() && (linkedWorld = MinecraftServer.func_71276_C().func_71218_a(dimension)) != null && linkedWorld != this.field_145850_b) {
            Chunk chunk = linkedWorld.func_72938_d(linkedPos.getX(), linkedPos.getZ());
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ForgeChunkManager.requestTicket((Object)RefinedRelocation.instance, (World)linkedWorld, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL), (ChunkCoordIntPair)new ChunkCoordIntPair(chunk.field_76635_g, chunk.field_76647_h));
            LogHelper.info("Force-loaded: " + linkedWorld.field_73011_w.func_80007_l());
        }
    }

    public void returnToOldBlock() {
        WorldServer linkedWorld;
        if (this.dimension != Integer.MAX_VALUE && (linkedWorld = MinecraftServer.func_71276_C().func_71218_a(this.dimension)) != null && linkedWorld != this.field_145850_b) {
            Chunk chunk = linkedWorld.func_72938_d(this.linkedPos.getX(), this.linkedPos.getZ());
            ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)ForgeChunkManager.requestTicket((Object)RefinedRelocation.instance, (World)linkedWorld, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL), (ChunkCoordIntPair)new ChunkCoordIntPair(chunk.field_76635_g, chunk.field_76647_h));
            LogHelper.info("Stopped force-load for: " + linkedWorld.field_73011_w.func_80007_l());
        }
        if (this.oldBlock == ModBlocks.relocationPortal || this.oldBlock == null) {
            this.oldBlock = Blocks.field_150350_a;
            this.oldMeta = 0;
        }
        this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.oldBlock, this.oldMeta, 3);
    }

    public void func_145845_h() {
        List entityList;
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.time = (byte)(this.time + 1);
        if (this.time > 60) {
            this.returnToOldBlock();
        }
        if (this.linkedPos != null && (entityList = this.field_145850_b.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1)))).size() >= 1) {
            EntityLivingBase entity = (EntityLivingBase)entityList.get(0);
            if (this.dimension != Integer.MAX_VALUE && this.dimension != this.field_145850_b.field_73011_w.field_76574_g) {
                TeleportHelper.travelToDimension((Entity)entity, this.dimension, this.linkedPos.getX(), this.linkedPos.getY() + 1, this.linkedPos.getZ());
            } else {
                TeleportHelper.travelToPosition((Entity)entity, this.linkedPos.getX(), this.linkedPos.getY() + 1, this.linkedPos.getZ());
            }
            TileEntity upperTile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
            if (upperTile != null && upperTile instanceof TileRelocationPortal) {
                ((TileRelocationPortal)upperTile).returnToOldBlock();
            }
            if ((upperTile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 2, this.field_145849_e)) != null && upperTile instanceof TileRelocationPortal) {
                ((TileRelocationPortal)upperTile).returnToOldBlock();
            }
            this.returnToOldBlock();
        }
    }

    public boolean isLower() {
        return this.linkedPos != null;
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74768_a("oldBlock", Block.func_149682_b((Block)this.oldBlock));
        compound.func_74768_a("oldMeta", this.oldMeta);
        compound.func_74768_a("dimension", this.dimension);
        compound.func_74774_a("time", this.time);
        if (this.linkedPos != null) {
            NBTTagCompound tag = new NBTTagCompound();
            this.linkedPos.writeToNBT(tag);
            compound.func_74782_a("linkedPos", (NBTBase)tag);
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.oldBlock = Block.func_149729_e((int)compound.func_74762_e("oldBlock"));
        this.oldMeta = compound.func_74762_e("oldMeta");
        this.dimension = compound.func_74762_e("dimension");
        this.time = compound.func_74771_c("time");
        if (compound.func_74764_b("linkedPos")) {
            NBTTagCompound tag = compound.func_74775_l("linkedPos");
            this.linkedPos = Vector3.createFromNBT(tag);
        }
    }
}

