/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.tileentity;

import com.dynious.refinedrelocation.api.APIUtils;
import com.dynious.refinedrelocation.api.filter.IFilterGUI;
import com.dynious.refinedrelocation.api.tileentity.IMultiFilterTile;
import com.dynious.refinedrelocation.api.tileentity.ISortingInventory;
import com.dynious.refinedrelocation.api.tileentity.handlers.ISortingInventoryHandler;
import com.dynious.refinedrelocation.block.BlockSortingIronChest;
import com.dynious.refinedrelocation.block.ModBlocks;
import com.dynious.refinedrelocation.helper.ItemStackHelper;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cpw.mods.ironchest.IronChestType;
import cpw.mods.ironchest.ItemChestChanger;
import cpw.mods.ironchest.TileEntityIronChest;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class TileSortingIronChest
extends TileEntityIronChest
implements ISortingInventory,
IMultiFilterTile {
    public boolean isFirstRun = true;
    private IFilterGUI filter = APIUtils.createStandardFilter(this);
    private ISortingInventoryHandler sortingInventoryHandler = APIUtils.createSortingInventoryHandler((TileEntity)this);
    private ISortingInventory.Priority priority = ISortingInventory.Priority.NORMAL;

    public TileSortingIronChest() {
    }

    public TileSortingIronChest(IronChestType type) {
        super(type);
    }

    public void func_145845_h() {
        if (this.isFirstRun) {
            this.sortingInventoryHandler.onTileAdded();
            this.isFirstRun = false;
        }
        super.func_145845_h();
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.sortingInventoryHandler.setInventorySlotContents(i, itemstack);
    }

    public TileEntityIronChest applyUpgradeItem(ItemChestChanger itemChestChanger) {
        if ((Integer)ReflectionHelper.getPrivateValue(TileEntityIronChest.class, (Object)this, (String[])new String[]{"numUsingPlayers"}) > 0) {
            return null;
        }
        if (!itemChestChanger.getType().canUpgrade(this.getType())) {
            return null;
        }
        TileSortingIronChest newEntity = new TileSortingIronChest(IronChestType.values()[itemChestChanger.getTargetChestOrdinal(this.getType().ordinal())]);
        int newSize = newEntity.chestContents.length;
        System.arraycopy(this.chestContents, 0, newEntity.chestContents, 0, Math.min(newSize, this.chestContents.length));
        BlockSortingIronChest block = ModBlocks.sortingIronChest;
        block.dropContent(newSize, this, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        NBTTagCompound filterTag = new NBTTagCompound();
        this.filter.writeToNBT(filterTag);
        newEntity.filter.readFromNBT(filterTag);
        newEntity.setFacing(this.getFacing());
        newEntity.sortTopStacks();
        ReflectionHelper.setPrivateValue(TileEntityIronChest.class, (Object)this, (Object)-1, (String[])new String[]{"ticksSinceSync"});
        return newEntity;
    }

    @Override
    public final boolean putStackInSlot(ItemStack itemStack, int slotIndex) {
        if (slotIndex >= 0 && slotIndex < this.chestContents.length) {
            this.chestContents[slotIndex] = itemStack;
            return true;
        }
        return false;
    }

    @Override
    public ItemStack putInInventory(ItemStack itemStack, boolean simulate) {
        int emptySlot = -1;
        for (int slot = 0; slot < this.func_70302_i_() && itemStack != null && itemStack.field_77994_a > 0; ++slot) {
            int max;
            if (!this.func_94041_b(slot, itemStack)) continue;
            ItemStack itemstack1 = this.func_70301_a(slot);
            if (itemstack1 == null) {
                if (simulate) {
                    return null;
                }
                if (emptySlot != -1) continue;
                emptySlot = slot;
                continue;
            }
            if (!ItemStackHelper.areItemStacksEqual(itemstack1, itemStack) || (max = Math.min(itemStack.func_77976_d(), this.func_70297_j_())) <= itemstack1.field_77994_a) continue;
            int l = Math.min(itemStack.field_77994_a, max - itemstack1.field_77994_a);
            itemStack.field_77994_a -= l;
            if (simulate) continue;
            itemstack1.field_77994_a += l;
            this.func_70296_d();
        }
        if (itemStack != null && itemStack.field_77994_a != 0 && emptySlot != -1) {
            this.chestContents[emptySlot] = itemStack;
            itemStack = null;
            this.func_70296_d();
        }
        return itemStack;
    }

    @Override
    public IFilterGUI getFilter() {
        return this.filter;
    }

    @Override
    public TileEntity getTileEntity() {
        return this;
    }

    @Override
    public void onFilterChanged() {
        this.func_70296_d();
    }

    @Override
    public ISortingInventory.Priority getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(ISortingInventory.Priority priority) {
        this.priority = priority;
    }

    @Override
    public ISortingInventoryHandler getHandler() {
        return this.sortingInventoryHandler;
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.getHandler().onInventoryChange();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldRenderInPass(int pass) {
        return pass == 0 || pass == 1;
    }

    public TileEntityIronChest updateFromMetadata(int l) {
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K && l != this.getType().ordinal()) {
            this.field_145850_b.func_147455_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)new TileSortingIronChest(IronChestType.values()[l]));
            return (TileEntityIronChest)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return this;
    }

    public void fixType(IronChestType type) {
        if (type != this.getType()) {
            ReflectionHelper.setPrivateValue(TileEntityIronChest.class, (Object)this, (Object)type, (String[])new String[]{"type"});
        }
        this.chestContents = new ItemStack[this.func_70302_i_()];
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.fixType(IronChestType.values()[compound.func_74771_c("type")]);
        super.func_145839_a(compound);
        this.filter.readFromNBT(compound);
        if (compound.func_74764_b("priority")) {
            this.setPriority(ISortingInventory.Priority.values()[compound.func_74771_c("priority")]);
        } else {
            this.setPriority(ISortingInventory.Priority.NORMAL);
        }
    }

    public void func_145841_b(NBTTagCompound compound) {
        compound.func_74774_a("type", (byte)this.getType().ordinal());
        super.func_145841_b(compound);
        this.filter.writeToNBT(compound);
        compound.func_74774_a("priority", (byte)this.priority.ordinal());
    }

    public void func_145843_s() {
        this.sortingInventoryHandler.onTileRemoved();
        this.isFirstRun = true;
        super.func_145843_s();
    }

    public void onChunkUnload() {
        this.sortingInventoryHandler.onTileRemoved();
        this.isFirstRun = true;
        super.onChunkUnload();
    }
}

