/*
 * Decompiled with CFR 0.152.
 */
package lib.enderwizards.sandstone.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import lib.enderwizards.sandstone.blocks.BlockBase;
import lib.enderwizards.sandstone.blocks.SubBlock;
import lib.enderwizards.sandstone.items.block.ItemBlockMultiple;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BlockMultiple
extends BlockBase {
    public final SubBlock[] blocks;

    public BlockMultiple(Material material, String name, Object[] items) {
        this(material, name, BlockMultiple.buildSubBlocks(items));
    }

    public BlockMultiple(Material material, String name, String[] names) {
        this(material, name, BlockMultiple.buildSubBlocks(names));
    }

    public BlockMultiple(Material material, String name, SubBlock[] blocks) {
        super(material, name);
        this.blocks = blocks;
        for (SubBlock block : blocks) {
            block.parent = this;
        }
    }

    private static SubBlock[] buildSubBlocks(String[] names) {
        ArrayList<SubBlock> items = new ArrayList<SubBlock>();
        for (String name : names) {
            items.add(new SubBlock(name));
        }
        return items.toArray(new SubBlock[items.size()]);
    }

    private static SubBlock[] buildSubBlocks(Object[] items) {
        ArrayList<SubBlock> newItems = new ArrayList<SubBlock>();
        for (Object item : items) {
            if (item instanceof String) {
                newItems.add(new SubBlock((String)item));
            }
            if (!(item instanceof SubBlock)) continue;
            newItems.add((SubBlock)item);
        }
        return newItems.toArray(new SubBlock[newItems.size()]);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        world.func_72921_c(x, y, z, stack.func_77960_j(), 3);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (meta < this.blocks.length) {
            return this.blocks[meta].getIcon(side);
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        for (SubBlock block : this.blocks) {
            block.registerIcons(iconRegister);
        }
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public int getLength() {
        return this.blocks.length;
    }

    @Override
    public Class<? extends ItemBlock> getCustomItemBlock() {
        return ItemBlockMultiple.class;
    }
}

