/*
 * Decompiled with CFR 0.152.
 */
package lib.enderwizards.sandstone.util.data;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import lib.enderwizards.sandstone.util.WorldSaveFile;
import lib.enderwizards.sandstone.util.misc.Duo;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ItemData
extends WorldSaveFile {
    private List<Duo<UUID, NBTTagCompound>> itemMap = new ArrayList<Duo<UUID, NBTTagCompound>>();

    public ItemData() {
        super("itemdata.nbt");
    }

    @Override
    protected void onSave(NBTTagCompound nbt) {
        NBTTagList itemsToSave = new NBTTagList();
        for (Duo<UUID, NBTTagCompound> item : this.itemMap) {
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74778_a("UUID", ((UUID)item.one).toString());
            itemTag.func_74782_a("NBTTag", (NBTBase)item.two);
            itemsToSave.func_74742_a((NBTBase)itemTag);
        }
        nbt.func_74782_a("Items", (NBTBase)itemsToSave);
    }

    @Override
    protected void onLoad(NBTTagCompound nbt) {
        if (nbt.func_150295_c("Items", 10) == null) {
            nbt.func_74782_a("Items", (NBTBase)new NBTTagList());
        }
        NBTTagList itemsToLoad = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < itemsToLoad.func_74745_c(); ++i) {
            NBTTagCompound itemTag = itemsToLoad.func_150305_b(i);
            Duo<UUID, NBTBase> duoTag = new Duo<UUID, NBTBase>(UUID.fromString(itemTag.func_74779_i("UUID")), itemTag.func_74781_a("NBTTag"));
            this.itemMap.add(duoTag);
        }
    }

    public NBTTagCompound getTag(UUID itemUUID) {
        for (Duo<UUID, NBTTagCompound> itemTag : this.itemMap) {
            if (!((UUID)itemTag.one).equals(itemUUID)) continue;
            return (NBTTagCompound)itemTag.two;
        }
        NBTTagCompound emptyCompound = new NBTTagCompound();
        this.setTag(itemUUID, emptyCompound);
        return emptyCompound;
    }

    public void setTag(UUID itemUUID, NBTTagCompound nbt) {
        this.resetTag(itemUUID);
        this.itemMap.add(new Duo<UUID, NBTTagCompound>(itemUUID, nbt));
        this.setModified();
    }

    public void resetTag(UUID itemUUID) {
        ArrayList<Duo<UUID, NBTTagCompound>> listSlatedForRemoval = new ArrayList<Duo<UUID, NBTTagCompound>>();
        for (Duo<UUID, NBTTagCompound> duo : this.itemMap) {
            if (!((UUID)duo.one).equals(itemUUID)) continue;
            listSlatedForRemoval.add(duo);
            break;
        }
        for (Duo<UUID, Object> duo : listSlatedForRemoval) {
            this.itemMap.remove(duo);
        }
    }
}

