/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.entities.shot;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import xreliquary.Reliquary;
import xreliquary.entities.shot.EntityBlazeShot;
import xreliquary.entities.shot.EntityBusterShot;
import xreliquary.entities.shot.EntityConcussiveShot;
import xreliquary.entities.shot.EntityEnderShot;
import xreliquary.entities.shot.EntityExorcismShot;
import xreliquary.entities.shot.EntityNeutralShot;
import xreliquary.entities.shot.EntitySandShot;
import xreliquary.entities.shot.EntitySeekerShot;
import xreliquary.entities.shot.EntityStormShot;
import xreliquary.lib.ClientReference;

public abstract class EntityShotBase
extends Entity
implements IProjectile {
    protected int xTile = -1;
    protected int yTile = -1;
    protected int zTile = -1;
    protected boolean inGround = false;
    public EntityPlayer shootingEntity;
    protected int ticksInAir = 0;
    protected int ricochetCounter = 0;
    protected boolean scheduledForDeath = false;

    public EntityShotBase(World par1World) {
        super(par1World);
        this.func_70105_a(0.01f, 0.01f);
    }

    public EntityShotBase(World par1World, double par2, double par4, double par6) {
        this(par1World);
        this.func_70107_b(par2, par4, par6);
        this.field_70129_M = 0.0f;
    }

    public EntityShotBase(World par1World, EntityPlayer par2EntityPlayer) {
        this(par1World);
        this.shootingEntity = par2EntityPlayer;
        float par3 = 0.8f;
        this.func_70012_b(par2EntityPlayer.field_70165_t, par2EntityPlayer.field_70163_u + (double)par2EntityPlayer.func_70047_e(), par2EntityPlayer.field_70161_v, par2EntityPlayer.field_70177_z, par2EntityPlayer.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.field_70163_u -= 0.2;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70129_M = 0.0f;
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, par3 * 1.5f, 1.0f);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(16, (Object)0);
    }

    public void func_70186_c(double var1, double var3, double var5, float var7, float var8) {
        float var9 = MathHelper.func_76133_a((double)(var1 * var1 + var3 * var3 + var5 * var5));
        var1 /= (double)var9;
        var3 /= (double)var9;
        var5 /= (double)var9;
        var1 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)var8;
        var3 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)var8;
        var5 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)var8;
        this.field_70159_w = var1 *= (double)var7;
        this.field_70181_x = var3 *= (double)var7;
        this.field_70179_y = var5 *= (double)var7;
        float var10 = MathHelper.func_76133_a((double)(var1 * var1 + var5 * var5));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(var1, var5) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(var3, var10) * 180.0 / Math.PI);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double par1, double par3, double par5, float par7, float par8, int par9) {
        this.func_70107_b(par1, par3, par5);
        this.func_70101_b(par7, par8);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double par1, double par3, double par5) {
        this.field_70159_w = par1;
        this.field_70181_x = par3;
        this.field_70179_y = par5;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float var7 = MathHelper.func_76133_a((double)(par1 * par1 + par5 * par5));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(par1, par5) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(par3, var7) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        }
    }

    protected void ensurePlayerShooterEntity() {
        if (this.shootingEntity == null) {
            List players = this.field_70170_p.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)(this.field_70165_t - 1.0), (double)(this.field_70163_u - 1.0), (double)(this.field_70161_v - 1.0), (double)(this.field_70165_t + 1.0), (double)(this.field_70163_u + 1.0), (double)(this.field_70161_v + 1.0)));
            Iterator i = players.iterator();
            double closestDistance = Double.MAX_VALUE;
            EntityPlayer closestPlayer = null;
            while (i.hasNext()) {
                EntityPlayer e = (EntityPlayer)i.next();
                double distance = e.func_70032_d((Entity)this);
                if (!(distance < closestDistance)) continue;
                closestPlayer = e;
            }
            if (closestPlayer != null) {
                this.shootingEntity = closestPlayer;
            }
        }
    }

    public void func_70071_h_() {
        Block block;
        super.func_70071_h_();
        if (this.ticksInAir > 600) {
            this.func_70106_y();
        }
        this.ensurePlayerShooterEntity();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float pythingy = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(this.field_70181_x, pythingy) * 180.0 / Math.PI);
        }
        if ((block = this.field_70170_p.func_147439_a(this.xTile, this.yTile, this.zTile)).func_149688_o() != Material.field_151579_a) {
            block.func_149719_a((IBlockAccess)this.field_70170_p, this.xTile, this.yTile, this.zTile);
            AxisAlignedBB axisalignedbb = block.func_149668_a(this.field_70170_p, this.xTile, this.yTile, this.zTile);
            if (axisalignedbb != null && axisalignedbb.func_72318_a(Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v))) {
                this.inGround = true;
            }
        }
        if (!this.inGround) {
            ++this.ticksInAir;
            if (this.ticksInAir > 1 && this.ticksInAir < 3) {
                this.field_70170_p.func_72869_a("flame", this.field_70165_t + this.smallGauss(0.1), this.field_70163_u + this.smallGauss(0.1), this.field_70161_v + this.smallGauss(0.1), 0.0, 0.0, 0.0);
                for (int particles = 0; particles < 3; ++particles) {
                    this.doFiringEffects();
                }
            } else {
                this.doFlightEffects();
            }
            Vec3 posVector = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
            Vec3 approachVector = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
            MovingObjectPosition objectStruckByVector = this.field_70170_p.func_147447_a(posVector, approachVector, false, true, false);
            posVector = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
            approachVector = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
            if (objectStruckByVector != null) {
                approachVector = Vec3.func_72443_a((double)objectStruckByVector.field_72307_f.field_72450_a, (double)objectStruckByVector.field_72307_f.field_72448_b, (double)objectStruckByVector.field_72307_f.field_72449_c);
            }
            Entity hitEntity = null;
            List struckEntitiesInAABB = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
            double var7 = 0.0;
            for (Entity struckEntity : struckEntitiesInAABB) {
                double var14;
                float var11;
                AxisAlignedBB var12;
                MovingObjectPosition var13;
                if (!struckEntity.func_70067_L() || struckEntity == this.shootingEntity && this.ticksInAir < 5 || (var13 = (var12 = struckEntity.field_70121_D.func_72314_b((double)(var11 = 0.5f), (double)var11, (double)var11)).func_72327_a(posVector, approachVector)) == null || !((var14 = posVector.func_72438_d(var13.field_72307_f)) < var7) && var7 != 0.0) continue;
                hitEntity = struckEntity;
                var7 = var14;
            }
            if (hitEntity != null) {
                objectStruckByVector = new MovingObjectPosition(hitEntity);
            }
            if (objectStruckByVector != null) {
                this.onImpact(objectStruckByVector);
                if (this.scheduledForDeath) {
                    this.func_70106_y();
                }
            }
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        par1NBTTagCompound.func_74777_a("xTile", (short)this.xTile);
        par1NBTTagCompound.func_74777_a("yTile", (short)this.yTile);
        par1NBTTagCompound.func_74777_a("zTile", (short)this.zTile);
        par1NBTTagCompound.func_74774_a("inGround", (byte)(this.inGround ? 1 : 0));
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        this.xTile = par1NBTTagCompound.func_74765_d("xTile");
        this.yTile = par1NBTTagCompound.func_74765_d("yTile");
        this.zTile = par1NBTTagCompound.func_74765_d("zTile");
        this.inGround = par1NBTTagCompound.func_74771_c("inGround") == 1;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.0f;
    }

    public boolean func_70075_an() {
        return false;
    }

    protected int d3() {
        return this.field_70146_Z.nextInt(3) + 1;
    }

    protected int d6() {
        return this.field_70146_Z.nextInt(6) + 1;
    }

    protected int d12() {
        return this.field_70146_Z.nextInt(12) + 1;
    }

    protected void doDamage(EntityLivingBase e) {
        e.func_70097_a(this.getDamageSource(), (e instanceof EntityPlayer ? 0.5f : 1.0f) * (float)this.getDamageOfShot(e));
    }

    protected DamageSource getDamageSource() {
        return DamageSource.func_76365_a((EntityPlayer)this.shootingEntity);
    }

    protected void groundImpact(int sideHit) {
        this.ricochet(sideHit);
    }

    protected double smallGauss(double d) {
        return ((double)this.field_70170_p.field_73012_v.nextFloat() - 0.5) * d;
    }

    protected double posGauss(double d) {
        return (double)this.field_70146_Z.nextFloat() * 0.5 * d;
    }

    protected double gaussian(double d) {
        return d + d * (((double)this.field_70146_Z.nextFloat() - 0.5) / 4.0);
    }

    protected double lowGauss(double d) {
        return d - d * ((double)(this.field_70146_Z.nextFloat() / 4.0f) + 0.5);
    }

    protected void ricochet(int sideHit) {
        switch (sideHit) {
            case 0: 
            case 1: {
                this.field_70181_x *= -1.0;
                break;
            }
            case 2: 
            case 3: {
                this.field_70179_y *= -1.0;
                break;
            }
            case 4: 
            case 5: {
                this.field_70159_w *= -1.0;
            }
        }
        ++this.ricochetCounter;
        if (this.ricochetCounter > this.getRicochetMax()) {
            this.doBurstEffect(sideHit);
            this.scheduledForDeath = true;
            block13: for (int particles = 0; particles < 4; ++particles) {
                switch (sideHit) {
                    case 0: {
                        this.field_70170_p.func_72869_a("smoke", this.field_70165_t, this.field_70163_u, this.field_70161_v, this.gaussian(0.1), -this.gaussian(0.1), this.gaussian(0.1));
                        continue block13;
                    }
                    case 1: {
                        this.field_70170_p.func_72869_a("smoke", this.field_70165_t, this.field_70163_u, this.field_70161_v, this.gaussian(0.1), this.gaussian(0.1), this.gaussian(0.1));
                        continue block13;
                    }
                    case 2: {
                        this.field_70170_p.func_72869_a("smoke", this.field_70165_t, this.field_70163_u, this.field_70161_v, this.gaussian(0.1), this.gaussian(0.1), -this.gaussian(0.1));
                        continue block13;
                    }
                    case 3: {
                        this.field_70170_p.func_72869_a("smoke", this.field_70165_t, this.field_70163_u, this.field_70161_v, this.gaussian(0.1), this.gaussian(0.1), this.gaussian(0.1));
                        continue block13;
                    }
                    case 4: {
                        this.field_70170_p.func_72869_a("smoke", this.field_70165_t, this.field_70163_u, this.field_70161_v, -this.gaussian(0.1), this.gaussian(0.1), this.gaussian(0.1));
                        continue block13;
                    }
                    case 5: {
                        this.field_70170_p.func_72869_a("smoke", this.field_70165_t, this.field_70163_u, this.field_70161_v, this.gaussian(0.1), this.gaussian(0.1), this.gaussian(0.1));
                    }
                }
            }
        }
    }

    protected void seekTarget() {
        Entity closestTarget = null;
        List entitiesThatCanBeHunted = (List)Reliquary.CONFIG.get("seeker_shot", "entities_that_can_be_hunted");
        List targetsList = this.field_70170_p.func_72839_b((Entity)this, AxisAlignedBB.func_72330_a((double)(this.field_70165_t - 5.0), (double)(this.field_70163_u - 5.0), (double)(this.field_70161_v - 5.0), (double)(this.field_70165_t + 5.0), (double)(this.field_70163_u + 5.0), (double)(this.field_70161_v + 5.0)));
        Iterator iTarget = targetsList.iterator();
        double closestDistance = Double.MAX_VALUE;
        while (iTarget.hasNext()) {
            Entity currentTarget = (Entity)iTarget.next();
            Class<?> entityClass = currentTarget.getClass();
            String entityName = (String)EntityList.field_75626_c.get(entityClass);
            if (!entitiesThatCanBeHunted.contains(entityName) || currentTarget == this.shootingEntity || currentTarget.field_70128_L || !((double)this.func_70032_d(currentTarget) < closestDistance)) continue;
            closestDistance = this.func_70032_d(currentTarget);
            closestTarget = currentTarget;
        }
        if (closestTarget != null && this.shootingEntity != null) {
            double x = closestTarget.field_70121_D.field_72340_a + closestTarget.field_70121_D.field_72336_d;
            x /= 2.0;
            double y = closestTarget.field_70121_D.field_72338_b + (double)Math.max(closestTarget.field_70129_M, closestTarget.field_70131_O);
            double z = closestTarget.field_70121_D.field_72339_c + closestTarget.field_70121_D.field_72334_f;
            double trueX = this.field_70121_D.field_72340_a + this.field_70121_D.field_72336_d;
            double trueY = this.field_70121_D.field_72338_b + (double)this.field_70129_M;
            double trueZ = this.field_70121_D.field_72339_c + this.field_70121_D.field_72334_f;
            Vec3 seekVector = Vec3.func_72443_a((double)(x - (trueX /= 2.0)), (double)((y -= (double)Math.max(closestTarget.field_70139_V, closestTarget.field_70131_O) / 2.0) - (trueY -= (double)this.field_70139_V / 2.0)), (double)((z /= 2.0) - (trueZ /= 2.0)));
            seekVector = seekVector.func_72432_b();
            this.field_70159_w = seekVector.field_72450_a * 0.4;
            this.field_70181_x = seekVector.field_72448_b * 0.4;
            this.field_70179_y = seekVector.field_72449_c * 0.4;
            if (this.field_70170_p.field_72995_K) {
                this.func_70016_h(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
        }
    }

    abstract int getRicochetMax();

    abstract int getDamageOfShot(EntityLivingBase var1);

    abstract void onImpact(EntityLivingBase var1);

    abstract void onImpact(MovingObjectPosition var1);

    abstract void doBurstEffect(int var1);

    abstract void doFiringEffects();

    abstract void doFlightEffects();

    abstract void spawnHitParticles(String var1, int var2);

    protected int getShotType() {
        if (this instanceof EntityNeutralShot) {
            return 1;
        }
        if (this instanceof EntityExorcismShot) {
            return 2;
        }
        if (this instanceof EntityBlazeShot) {
            return 3;
        }
        if (this instanceof EntityEnderShot) {
            return 4;
        }
        if (this instanceof EntityConcussiveShot) {
            return 5;
        }
        if (this instanceof EntityBusterShot) {
            return 6;
        }
        if (this instanceof EntitySeekerShot) {
            return 7;
        }
        if (this instanceof EntitySandShot) {
            return 8;
        }
        if (this instanceof EntityStormShot) {
            return 9;
        }
        return 0;
    }

    public ResourceLocation getShotTexture() {
        switch (this.getShotType()) {
            case 0: 
            case 1: {
                return ClientReference.NEUTRAL;
            }
            case 2: {
                return ClientReference.EXORCISM;
            }
            case 3: {
                return ClientReference.BLAZE;
            }
            case 4: {
                return ClientReference.ENDER;
            }
            case 5: {
                return ClientReference.CONCUSSIVE;
            }
            case 6: {
                return ClientReference.BUSTER;
            }
            case 7: {
                return ClientReference.SEEKER;
            }
            case 8: {
                return ClientReference.SAND;
            }
            case 9: {
                return ClientReference.STORM;
            }
        }
        return ClientReference.NEUTRAL;
    }

    protected void doBurstEffect() {
        this.doBurstEffect(0);
    }
}

