/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import lib.enderwizards.sandstone.init.ContentInit;
import lib.enderwizards.sandstone.items.ItemBase;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import xreliquary.Reliquary;

@ContentInit
public class ItemShearsOfWinter
extends ItemBase {
    public ItemShearsOfWinter() {
        super("shears_of_winter");
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.canRepair = false;
    }

    public boolean func_150894_a(ItemStack ist, World world, Block block, int x, int y, int z, EntityLivingBase player) {
        if (block.func_149688_o() != Material.field_151584_j && block != Blocks.field_150321_G && block != Blocks.field_150329_H && block != Blocks.field_150395_bd && block != Blocks.field_150473_bD && !(block instanceof IShearable)) {
            return super.func_150894_a(ist, world, block, x, y, z, player);
        }
        return true;
    }

    public boolean func_150897_b(Block block) {
        return block == Blocks.field_150321_G || block == Blocks.field_150488_af || block == Blocks.field_150473_bD;
    }

    public float func_150893_a(ItemStack ist, Block block) {
        return block != Blocks.field_150321_G && block.func_149688_o() != Material.field_151584_j ? (block == Blocks.field_150325_L ? 5.0f : super.func_150893_a(ist, block)) : 15.0f;
    }

    public boolean func_111207_a(ItemStack itemstack, EntityPlayer player, EntityLivingBase entity) {
        if (entity.field_70170_p.field_72995_K) {
            return false;
        }
        if (entity instanceof IShearable) {
            IShearable target = (IShearable)entity;
            if (target.isShearable(itemstack, (IBlockAccess)entity.field_70170_p, (int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v)) {
                ArrayList drops = target.onSheared(itemstack, (IBlockAccess)entity.field_70170_p, (int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)itemstack));
                Random rand = new Random();
                for (ItemStack stack : drops) {
                    EntityItem ent = entity.func_70099_a(stack, 1.0f);
                    ent.field_70181_x += (double)(rand.nextFloat() * 0.05f);
                    ent.field_70159_w += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                    ent.field_70179_y += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                }
                itemstack.func_77972_a(1, entity);
            }
            return true;
        }
        return false;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, int x, int y, int z, EntityPlayer player) {
        IShearable target;
        if (player.field_70170_p.field_72995_K) {
            return false;
        }
        Block block = player.field_70170_p.func_147439_a(x, y, z);
        if (block instanceof IShearable && (target = (IShearable)block).isShearable(itemstack, (IBlockAccess)player.field_70170_p, x, y, z)) {
            ArrayList drops = target.onSheared(itemstack, (IBlockAccess)player.field_70170_p, x, y, z, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)itemstack));
            Random rand = new Random();
            for (ItemStack stack : drops) {
                float f = 0.7f;
                double d = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(player.field_70170_p, (double)x + d, (double)y + d1, (double)z + d2, stack);
                entityitem.field_145804_b = 10;
                player.field_70170_p.func_72838_d((Entity)entityitem);
            }
            itemstack.func_77972_a(1, (EntityLivingBase)player);
            player.func_71064_a(StatList.field_75934_C[Block.func_149682_b((Block)block)], 1);
        }
        return false;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 2500;
    }

    public EnumAction func_77661_b(ItemStack ist) {
        return EnumAction.block;
    }

    public ItemStack func_77659_a(ItemStack ist, World world, EntityPlayer player) {
        player.func_71008_a(ist, this.func_77626_a(ist));
        return ist;
    }

    public void onUsingTick(ItemStack ist, EntityPlayer player, int count) {
        if (this.func_77626_a(ist) - count <= 5) {
            return;
        }
        Vec3 lookVector = player.func_70040_Z();
        this.spawnBlizzardParticles(lookVector, player);
        this.doEntityShearableCheck(ist, player, lookVector);
        if (lookVector.field_72450_a > 0.0) {
            this.doPositiveXCheck(ist, player, lookVector);
        } else {
            this.doNegativeXCheck(ist, player, lookVector);
        }
    }

    public void doPositiveXCheck(ItemStack ist, EntityPlayer player, Vec3 lookVector) {
        int x;
        boolean firedOnce = false;
        for (x = 0; x < (int)(lookVector.field_72450_a * 10.0); ++x) {
            firedOnce = true;
            if (lookVector.field_72448_b > 0.0) {
                this.doPositiveYCheck(ist, player, lookVector, x);
                continue;
            }
            this.doNegativeYCheck(ist, player, lookVector, x);
        }
        if (!firedOnce) {
            for (x = -2; x <= 2; ++x) {
                if (lookVector.field_72448_b > 0.0) {
                    this.doPositiveYCheck(ist, player, lookVector, x);
                    continue;
                }
                this.doNegativeYCheck(ist, player, lookVector, x);
            }
        }
    }

    public void doNegativeXCheck(ItemStack ist, EntityPlayer player, Vec3 lookVector) {
        int x;
        boolean firedOnce = false;
        for (x = 0; x > (int)(lookVector.field_72450_a * 10.0); --x) {
            firedOnce = true;
            if (lookVector.field_72448_b > 0.0) {
                this.doPositiveYCheck(ist, player, lookVector, x);
                continue;
            }
            this.doNegativeYCheck(ist, player, lookVector, x);
        }
        if (!firedOnce) {
            for (x = -2; x <= 2; ++x) {
                if (lookVector.field_72448_b > 0.0) {
                    this.doPositiveYCheck(ist, player, lookVector, x);
                    continue;
                }
                this.doNegativeYCheck(ist, player, lookVector, x);
            }
        }
    }

    public void doPositiveYCheck(ItemStack ist, EntityPlayer player, Vec3 lookVector, int x) {
        int y;
        boolean firedOnce = false;
        for (y = 0; y < (int)(lookVector.field_72448_b * 10.0); ++y) {
            firedOnce = true;
            if (lookVector.field_72449_c > 0.0) {
                this.doPositiveZCheck(ist, player, lookVector, x, y);
                continue;
            }
            this.doNegativeZCheck(ist, player, lookVector, x, y);
        }
        if (!firedOnce) {
            for (y = -2; y <= 2; ++y) {
                if (lookVector.field_72449_c > 0.0) {
                    this.doPositiveZCheck(ist, player, lookVector, x, y);
                    continue;
                }
                this.doNegativeZCheck(ist, player, lookVector, x, y);
            }
        }
    }

    public void doNegativeYCheck(ItemStack ist, EntityPlayer player, Vec3 lookVector, int x) {
        int y;
        boolean firedOnce = false;
        for (y = 0; y > (int)(lookVector.field_72448_b * 10.0); --y) {
            firedOnce = true;
            if (lookVector.field_72449_c > 0.0) {
                this.doPositiveZCheck(ist, player, lookVector, x, y);
                continue;
            }
            this.doNegativeZCheck(ist, player, lookVector, x, y);
        }
        if (!firedOnce) {
            for (y = -2; y <= 2; ++y) {
                if (lookVector.field_72449_c > 0.0) {
                    this.doPositiveZCheck(ist, player, lookVector, x, y);
                    continue;
                }
                this.doNegativeZCheck(ist, player, lookVector, x, y);
            }
        }
    }

    public void doPositiveZCheck(ItemStack ist, EntityPlayer player, Vec3 lookVector, int x, int y) {
        int z;
        boolean firedOnce = false;
        for (z = 0; z < (int)(lookVector.field_72449_c * 10.0); ++z) {
            firedOnce = true;
            this.checkAndBreakBlockAt(x, y, z, player, ist);
        }
        if (!firedOnce) {
            for (z = -2; z <= 2; ++z) {
                this.checkAndBreakBlockAt(x, y, z, player, ist);
            }
        }
    }

    public void doNegativeZCheck(ItemStack ist, EntityPlayer player, Vec3 lookVector, int x, int y) {
        int z;
        boolean firedOnce = false;
        for (z = 0; z > (int)(lookVector.field_72449_c * 10.0); --z) {
            firedOnce = true;
            this.checkAndBreakBlockAt(x, y, z, player, ist);
        }
        if (!firedOnce) {
            for (z = -2; z <= 2; ++z) {
                this.checkAndBreakBlockAt(x, y, z, player, ist);
            }
        }
    }

    public void checkAndBreakBlockAt(int x, int y, int z, EntityPlayer player, ItemStack ist) {
        int distance = (int)player.func_70011_f((double)(x += (int)player.field_70165_t), (double)(y += (int)(player.field_70163_u + (double)player.func_70047_e())), (double)(z += (int)player.field_70161_v));
        int probabilityFactor = 5 + distance;
        if (player.field_70170_p.field_73012_v.nextInt(probabilityFactor) == 0) {
            IShearable target;
            Block block = player.field_70170_p.func_147439_a(x, y, z);
            if (block instanceof IShearable && (target = (IShearable)block).isShearable(new ItemStack((Item)Items.field_151097_aZ, 1, 0), (IBlockAccess)player.field_70170_p, x, y, z)) {
                ArrayList drops = block.getDrops(player.field_70170_p, x, y, z, player.field_70170_p.func_72805_g(x, y, z), EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)ist));
                Random rand = new Random();
                if (player.field_70170_p.field_72995_K) {
                    if (block.func_149688_o() != Material.field_151579_a) {
                        player.field_70170_p.func_72889_a(player, 2001, x, y, z, Block.func_149682_b((Block)block) + (player.field_70170_p.func_72805_g(x, y, z) << 12));
                    }
                } else {
                    for (ItemStack stack : drops) {
                        float f = 0.7f;
                        double d = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                        double d1 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                        double d2 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                        EntityItem entityitem = new EntityItem(player.field_70170_p, (double)x + d, (double)y + d1, (double)z + d2, stack);
                        entityitem.field_145804_b = 10;
                        player.field_70170_p.func_72838_d((Entity)entityitem);
                    }
                    player.field_70170_p.func_147449_b(x, y, z, Blocks.field_150350_a);
                    player.func_71064_a(StatList.field_75934_C[Block.func_149682_b((Block)block)], 1);
                    player.func_71020_j(0.01f);
                }
            }
            return;
        }
    }

    public void doEntityShearableCheck(ItemStack ist, EntityPlayer player, Vec3 lookVector) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        double lowerX = Math.min(player.field_70165_t, player.field_70165_t + lookVector.field_72450_a * 10.0);
        double lowerY = Math.min(player.field_70163_u + (double)player.func_70047_e(), player.field_70163_u + (double)player.func_70047_e() + lookVector.field_72448_b * 10.0);
        double lowerZ = Math.min(player.field_70161_v, player.field_70161_v + lookVector.field_72449_c * 10.0);
        double upperX = Math.max(player.field_70165_t, player.field_70165_t + lookVector.field_72450_a * 10.0);
        double upperY = Math.max(player.field_70163_u + (double)player.func_70047_e(), player.field_70163_u + (double)player.func_70047_e() + lookVector.field_72448_b * 10.0);
        double upperZ = Math.max(player.field_70161_v, player.field_70161_v + lookVector.field_72449_c * 10.0);
        List eList = player.field_70170_p.func_72872_a(EntityLiving.class, AxisAlignedBB.func_72330_a((double)lowerX, (double)lowerY, (double)lowerZ, (double)upperX, (double)upperY, (double)upperZ));
        for (Entity e : eList) {
            IShearable target;
            int distance = (int)player.func_70032_d(e);
            int probabilityFactor = (distance - 3) / 2;
            if (probabilityFactor > 0 && player.field_70170_p.field_73012_v.nextInt(probabilityFactor) != 0) continue;
            if (e instanceof EntityLivingBase && !e.func_70028_i((Entity)player)) {
                ((EntityLivingBase)e).func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 120, 1));
            }
            if (!(e instanceof IShearable) || !(target = (IShearable)e).isShearable(new ItemStack((Item)Items.field_151097_aZ, 1, 0), (IBlockAccess)e.field_70170_p, (int)e.field_70165_t, (int)e.field_70163_u, (int)e.field_70161_v)) continue;
            ArrayList drops = target.onSheared(new ItemStack((Item)Items.field_151097_aZ, 1, 0), (IBlockAccess)e.field_70170_p, (int)e.field_70165_t, (int)e.field_70163_u, (int)e.field_70161_v, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)ist));
            Random rand = new Random();
            for (ItemStack stack : drops) {
                EntityItem ent = e.func_70099_a(stack, 1.0f);
                ent.field_70181_x += (double)(rand.nextFloat() * 0.05f);
                ent.field_70159_w += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                ent.field_70179_y += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
            }
            player.func_71020_j(0.01f);
        }
    }

    public void spawnBlizzardParticles(Vec3 lookVector, EntityPlayer player) {
        for (int i = 0; i < 16; ++i) {
            float randX = 10.0f * (player.field_70170_p.field_73012_v.nextFloat() - 0.5f);
            float randY = 10.0f * (player.field_70170_p.field_73012_v.nextFloat() - 0.5f);
            float randZ = 10.0f * (player.field_70170_p.field_73012_v.nextFloat() - 0.5f);
            player.field_70170_p.func_72869_a("blockdust_" + Block.func_149682_b((Block)Blocks.field_150431_aC) + "_" + 0, player.field_70165_t + (double)randX, player.field_70163_u + (double)randY, player.field_70161_v + (double)randZ, lookVector.field_72450_a * 5.0, lookVector.field_72448_b * 5.0, lookVector.field_72449_c * 5.0);
        }
    }
}

