/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.api.message.element;

import chylex.hee.api.message.element.IntValue;
import chylex.hee.api.message.element.base.Precondition;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;

public abstract class IntArrayValue
extends Precondition<int[]> {
    public static final IntArrayValue any() {
        return new IntArrayValueAny();
    }

    public static final IntArrayValue condition(Precondition<Integer> condition) {
        return new IntArrayValueCondition(condition, IntValue.any());
    }

    public static final IntArrayValue condition(Precondition<Integer> condition, Precondition<Integer> elementCount) {
        return new IntArrayValueCondition(condition, elementCount);
    }

    IntArrayValue() {
    }

    @Override
    public final boolean checkType(NBTBase tag) {
        return tag != null && tag.func_74732_a() == 11;
    }

    @Override
    public final int[] getValue(NBTBase tag) {
        return ((NBTTagIntArray)tag).func_150302_c();
    }

    private static class IntArrayValueCondition
    extends IntArrayValue {
        private final Precondition<Integer> condition;
        private final Precondition<Integer> elementCount;

        IntArrayValueCondition(Precondition<Integer> condition, Precondition<Integer> elementCount) {
            this.condition = condition;
            this.elementCount = elementCount;
        }

        @Override
        public boolean checkValue(NBTBase tag) {
            if (!this.elementCount.checkValue((NBTBase)new NBTTagInt(this.getValue(tag).length))) {
                return false;
            }
            for (int value : this.getValue(tag)) {
                if (this.condition.checkValue((NBTBase)new NBTTagInt(value))) continue;
                return false;
            }
            return true;
        }
    }

    private static class IntArrayValueAny
    extends IntArrayValue {
        IntArrayValueAny() {
        }

        @Override
        public boolean checkValue(NBTBase tag) {
            return true;
        }
    }
}

