/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.entity.mob.ai;

import chylex.hee.entity.mob.ai.base.EntityAIAbstractContinuous;
import chylex.hee.system.abstractions.BlockInfo;
import chylex.hee.system.abstractions.Pos;
import chylex.hee.system.util.WorldUtil;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityCreature;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;

public class EntityAIMoveBlocksRandomly
extends EntityAIAbstractContinuous {
    private final EntityCreature entity;
    private final IMoveBlocks moveHandler;
    private final Set<Block> validBlocks;
    private float stealChance = 0.005f;
    private float placeChance = 0.0025f;

    public EntityAIMoveBlocksRandomly(EntityCreature owner, IMoveBlocks moveHandler, Set<Block> validBlocks) {
        this.entity = owner;
        this.moveHandler = moveHandler;
        this.validBlocks = validBlocks;
    }

    public EntityAIMoveBlocksRandomly setStealChancePerTick(float chance) {
        this.stealChance = chance;
        return this;
    }

    public EntityAIMoveBlocksRandomly setPlaceChancePerTick(float chance) {
        this.placeChance = chance;
        return this;
    }

    @Override
    protected void tick() {
        block5: {
            BlockInfo holding;
            Random rand;
            block6: {
                if (this.entity.func_70638_az() != null || !WorldUtil.getRuleBool(this.entity.field_70170_p, WorldUtil.GameRule.MOB_GRIEFING)) {
                    return;
                }
                rand = this.entity.func_70681_au();
                holding = this.moveHandler.getCarryingBlock();
                if (holding.block != Blocks.field_150350_a || !(rand.nextFloat() < this.stealChance)) break block6;
                for (int attempt = 0; attempt < 5; ++attempt) {
                    Pos pos = this.moveHandler.findBlockStealPosition(this.entity);
                    if (pos == null) {
                        return;
                    }
                    if (!this.validBlocks.contains(pos.getBlock((IBlockAccess)this.entity.field_70170_p))) continue;
                    this.moveHandler.setCarryingBlock(pos.getInfo((IBlockAccess)this.entity.field_70170_p));
                    pos.setAir(this.entity.field_70170_p);
                    break block5;
                }
                break block5;
            }
            if (holding.block == Blocks.field_150350_a || !(rand.nextFloat() < this.placeChance)) break block5;
            for (int attempt = 0; attempt < 5; ++attempt) {
                Pos pos = this.moveHandler.findBlockPlacePosition(this.entity);
                if (pos == null) {
                    return;
                }
                Pos below = pos.getDown();
                if (!pos.isAir((IBlockAccess)this.entity.field_70170_p) || below.isAir((IBlockAccess)this.entity.field_70170_p) || !below.getBlock((IBlockAccess)this.entity.field_70170_p).func_149686_d()) continue;
                this.moveHandler.setCarryingBlock(null);
                pos.setBlock(this.entity.field_70170_p, holding);
                break;
            }
        }
    }

    public static interface IMoveBlocks {
        public void setCarryingBlock(@Nullable BlockInfo var1);

        @Nonnull
        public BlockInfo getCarryingBlock();

        @Nullable
        default public Pos findBlockStealPosition(EntityCreature entity) {
            return Pos.at((double)(entity.field_70165_t + (entity.func_70681_au().nextDouble() - 0.5) * 4.0), (double)(entity.field_70163_u + entity.func_70681_au().nextDouble() * 3.0), (double)(entity.field_70161_v + (entity.func_70681_au().nextDouble() - 0.5) * 4.0));
        }

        @Nullable
        default public Pos findBlockPlacePosition(EntityCreature entity) {
            return Pos.at((double)(entity.field_70165_t + (entity.func_70681_au().nextDouble() - 0.5) * 3.0), (double)(entity.field_70163_u + entity.func_70681_au().nextDouble() * 2.0), (double)(entity.field_70161_v + (entity.func_70681_au().nextDouble() - 0.5) * 3.0));
        }
    }
}

