/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.entity.mob.ai.target;

import chylex.hee.entity.mob.ai.base.EntityAIAbstractTarget;
import chylex.hee.system.abstractions.Vec;
import chylex.hee.system.abstractions.entity.EntitySelector;
import chylex.hee.system.util.MathUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class EntityAIDirectLookTarget
extends EntityAIAbstractTarget {
    private final ITargetOnDirectLook lookHandler;
    private double maxDistance = 32.0;
    private int tickLimiter;
    private int lookTimer;

    public EntityAIDirectLookTarget(EntityCreature owner, ITargetOnDirectLook lookHandler) {
        super(owner, true, false);
        this.lookHandler = lookHandler;
    }

    public EntityAIDirectLookTarget setMaxDistance(double maxDistance) {
        this.maxDistance = maxDistance;
        return this;
    }

    @Override
    protected EntityLivingBase findNewTarget() {
        if (++this.tickLimiter < 2) {
            return null;
        }
        this.tickLimiter = 0;
        for (EntityPlayer player : EntitySelector.players((World)this.field_75299_d.field_70170_p, (AxisAlignedBB)this.field_75299_d.field_70121_D.func_72314_b(this.maxDistance, this.maxDistance, this.maxDistance))) {
            double dist = MathUtil.distance(player.field_70165_t - this.field_75299_d.field_70165_t, player.field_70163_u - this.field_75299_d.field_70163_u, player.field_70161_v - this.field_75299_d.field_70161_v);
            if (!(dist <= this.maxDistance) || !this.isPlayerLookingIntoEyes(player) || !this.lookHandler.canTargetOnDirectLook(player, dist)) continue;
            if (++this.lookTimer == 4) {
                this.lookTimer = 0;
                return player;
            }
            return null;
        }
        this.lookTimer = 0;
        return null;
    }

    private boolean isPlayerLookingIntoEyes(EntityPlayer target) {
        ItemStack headIS = target.field_71071_by.field_70460_b[3];
        if (headIS != null && headIS.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150423_aK)) {
            return false;
        }
        Vec posDiff = Vec.between((Entity)target, (Entity)this.field_75299_d);
        posDiff.y += (double)this.field_75299_d.field_70131_O * 0.9 - (double)target.func_70047_e();
        double dist = posDiff.length();
        double dot = Vec.xyzLook((EntityLivingBase)target).dotProduct(posDiff.normalized());
        return Math.abs(dot - 1.0) < 0.05 / MathUtil.square(dist) && target.func_70685_l((Entity)this.field_75299_d);
    }

    @FunctionalInterface
    public static interface ITargetOnDirectLook {
        public boolean canTargetOnDirectLook(EntityPlayer var1, double var2);
    }
}

