/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.entity.technical;

import chylex.hee.entity.technical.EntityTechnicalBase;
import chylex.hee.system.abstractions.Vec;
import chylex.hee.system.abstractions.entity.EntitySelector;
import chylex.hee.system.logging.Log;
import chylex.hee.world.util.BoundingBox;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class EntityTechnicalSpawner<T extends EntityLiving>
extends EntityTechnicalBase {
    private IVirtualSpawner<T> spawner;
    private int timer = -1;

    public EntityTechnicalSpawner(World world) {
        super(world);
    }

    public EntityTechnicalSpawner(World world, double x, double y, double z, IVirtualSpawner<T> spawner) {
        super(world);
        this.func_70107_b(x, y, z);
        this.spawner = spawner;
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.spawner == null) {
            this.func_70106_y();
        } else if (this.timer == -1) {
            this.spawner.init(this);
            this.timer = this.spawner.getCheckTimer(this.field_70146_Z);
        } else if (--this.timer == 0) {
            this.timer = this.spawner.getCheckTimer(this.field_70146_Z);
            ImmutableList players = ImmutableList.copyOf(this.spawner.getPlayersInRange(this.field_70170_p));
            if (!players.isEmpty()) {
                for (EntityPlayer player : players) {
                    int mobsLeft = this.spawner.getSpawnLimit(this.field_70146_Z);
                    if (mobsLeft == 0) continue;
                    for (int attemptsLeft = this.spawner.getSpawnAttempts(this.field_70146_Z); attemptsLeft > 0 && mobsLeft > 0; --attemptsLeft) {
                        T entity = this.spawner.createEntity(this.field_70170_p);
                        this.spawner.findSpawnPosition(this.field_70170_p, this.field_70146_Z, player, entity, this.spawner.getSpawnRange(this.field_70146_Z));
                        if (!this.spawner.checkSpawnConditions(this.field_70170_p, this.field_70146_Z, (ImmutableList<EntityPlayer>)players, player, entity)) continue;
                        this.field_70170_p.func_72838_d(entity);
                        --mobsLeft;
                    }
                }
            }
        }
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        if (this.spawner != null) {
            nbt.func_74778_a("spawnerCls", this.spawner.getClass().getName());
        }
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        try {
            this.spawner = (IVirtualSpawner)Class.forName(nbt.func_74779_i("spawnerCls")).newInstance();
        }
        catch (Throwable t) {
            Log.throwable(t, "Unable to load a spawner entity: $0", nbt.func_74779_i("spawnerCls"));
            this.func_70106_y();
        }
    }

    public static interface IVirtualSpawner<T extends EntityLiving> {
        public void init(EntityTechnicalSpawner var1);

        public T createEntity(World var1);

        public int getCheckTimer(Random var1);

        public int getSpawnAttempts(Random var1);

        public int getSpawnLimit(Random var1);

        public double getSpawnRange(Random var1);

        public BoundingBox getCheckBox();

        default public List<EntityPlayer> getPlayersInRange(World world) {
            return EntitySelector.players((World)world, (AxisAlignedBB)this.getCheckBox().toAABB());
        }

        default public void findSpawnPosition(World world, Random rand, EntityPlayer target, T entity, double range) {
            Vec vec = Vec.xzRandom(rand);
            entity.func_70080_a(target.field_70165_t + vec.x * range, target.field_70163_u + (rand.nextDouble() - 0.5) * range, target.field_70161_v + vec.z * range, rand.nextFloat() * 360.0f - 180.0f, 0.0f);
        }

        default public boolean checkSpawnConditions(World world, Random rand, ImmutableList<EntityPlayer> playersInRange, EntityPlayer target, T entity) {
            return entity.func_70601_bi();
        }
    }
}

