/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.game.save;

import chylex.hee.game.save.ISaveDataHandler;
import chylex.hee.game.save.SaveFile;
import chylex.hee.game.save.handlers.GlobalDataHandler;
import chylex.hee.game.save.handlers.PlayerDataHandler;
import chylex.hee.game.save.types.PlayerFile;
import chylex.hee.system.logging.Log;
import chylex.hee.system.util.GameRegistryUtil;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.world.WorldEvent;

public final class SaveData {
    private static final SaveData instance = new SaveData();
    private final GlobalDataHandler global = new GlobalDataHandler();
    private final PlayerDataHandler player = new PlayerDataHandler();
    private final ISaveDataHandler[] handlers = new ISaveDataHandler[]{this.global, this.player};
    private File worldSaveDir;
    private String worldIdentifier = "";

    public static void register() {
        GameRegistryUtil.registerEventHandler((Object)instance);
        for (ISaveDataHandler handler : SaveData.instance.handlers) {
            handler.register();
        }
    }

    public static <T extends SaveFile> T global(Class<T> cls) {
        return (T)SaveData.instance.global.get(cls);
    }

    public static <T extends PlayerFile> T player(EntityPlayer player, Class<T> cls) {
        return (T)SaveData.instance.player.get(player, cls);
    }

    public static <T extends PlayerFile> T player(String playerID, Class<T> cls) {
        return (T)SaveData.instance.player.get(playerID, cls);
    }

    private SaveData() {
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load e) {
        if (e.world.field_72995_K) {
            return;
        }
        String id = e.world.func_72860_G().func_75760_g() + e.world.func_72912_H().func_76065_j() + e.world.func_72912_H().func_76063_b();
        if (!this.worldIdentifier.equals(id)) {
            this.worldIdentifier = id;
            File root = DimensionManager.getCurrentSaveRootDirectory();
            if (root == null) {
                throw new IllegalStateException("Could not determine world save directory!");
            }
            this.worldSaveDir = new File(root, "hee2");
            if (!this.worldSaveDir.exists()) {
                this.worldSaveDir.mkdirs();
            }
            for (ISaveDataHandler handler : this.handlers) {
                handler.clear(this.worldSaveDir);
            }
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save e) {
        if (this.worldSaveDir == null) {
            return;
        }
        for (ISaveDataHandler handler : this.handlers) {
            handler.save();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NBTTagCompound readFile(File file) {
        if (!file.exists()) return new NBTTagCompound();
        try (FileInputStream fileStream = new FileInputStream(file);){
            NBTTagCompound nBTTagCompound = CompressedStreamTools.func_74796_a((InputStream)fileStream);
            return nBTTagCompound;
        }
        catch (IOException ioe) {
            Log.throwable(ioe, "Error reading NBT file - $0", file);
        }
        return new NBTTagCompound();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean saveFile(File file, NBTTagCompound nbt) {
        try (FileOutputStream fileStream = new FileOutputStream(file);){
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)fileStream);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            Log.throwable(ex, "Error writing NBT file $0", file);
            return false;
        }
    }
}

