/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.system.util;

import chylex.hee.game.commands.HeeDebugCommand;
import chylex.hee.system.logging.Stopwatch;
import java.util.Random;

public class FastRandom {
    private long last;
    public static final HeeDebugCommand.HeeTest $debugTest = new HeeDebugCommand.HeeTest(){

        public void run(String ... args) {
            int a;
            int cycles = 5000000;
            FastRandom fast = new FastRandom();
            Random slow = new Random();
            Stopwatch.time("nextInt - fast");
            for (a = 0; a < 5000000; ++a) {
                fast.nextInt(Integer.MAX_VALUE);
            }
            Stopwatch.finish("nextInt - fast");
            Stopwatch.time("nextInt - slow");
            for (a = 0; a < 5000000; ++a) {
                slow.nextInt(Integer.MAX_VALUE);
            }
            Stopwatch.finish("nextInt - slow");
            Stopwatch.time("nextFloat - fast");
            for (a = 0; a < 5000000; ++a) {
                fast.nextFloat();
            }
            Stopwatch.finish("nextFloat - fast");
            Stopwatch.time("nextFloat - slow");
            for (a = 0; a < 5000000; ++a) {
                slow.nextFloat();
            }
            Stopwatch.finish("nextFloat - slow");
            Stopwatch.time("nextDouble - fast");
            for (a = 0; a < 5000000; ++a) {
                fast.nextDouble();
            }
            Stopwatch.finish("nextDouble - fast");
            Stopwatch.time("nextDouble - slow");
            for (a = 0; a < 5000000; ++a) {
                slow.nextDouble();
            }
            Stopwatch.finish("nextDouble - slow");
            Stopwatch.time("nextLong - fast");
            for (a = 0; a < 5000000; ++a) {
                fast.nextLong();
            }
            Stopwatch.finish("nextLong - fast");
            Stopwatch.time("nextLong - slow");
            for (a = 0; a < 5000000; ++a) {
                slow.nextLong();
            }
            Stopwatch.finish("nextLong - slow");
        }
    };

    public FastRandom() {
        this.last = System.currentTimeMillis();
    }

    public FastRandom(long seed) {
        this.last = seed == 0L ? 1L : seed;
    }

    protected long next() {
        this.last ^= this.last << 21;
        this.last ^= this.last >>> 35;
        this.last ^= this.last << 4;
        return this.last - 1L;
    }

    public long nextLong() {
        return Math.abs(this.next());
    }

    public int nextInt(int max) {
        return Math.abs((int)this.next() % max);
    }

    public float nextFloat() {
        return (float)Math.abs((double)this.next() / 9.223372036854776E18);
    }

    public double nextDouble() {
        return Math.abs((double)this.next() / 9.223372036854776E18);
    }
}

