/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.loot;

import chylex.hee.world.loot.interfaces.IItemPostProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public abstract class LootTable<ITEM extends LootItem> {
    protected final List<IItemPostProcessor> postProcessors = new ArrayList<IItemPostProcessor>();

    abstract ITEM createLootItem(Item var1);

    public final ITEM addLoot(Block block) {
        Item item = Item.func_150898_a((Block)block);
        if (item == null) {
            throw new IllegalArgumentException("Invalid block, no item found: " + block);
        }
        return this.createLootItem(item);
    }

    public final ITEM addLoot(Item item) {
        return this.createLootItem(item);
    }

    public final void addPostProcessor(IItemPostProcessor processor) {
        this.postProcessors.add(processor);
    }

    public abstract class LootItem {
        protected final Item item;

        LootItem(Item item) {
            if (item == null) {
                throw new IllegalArgumentException("Item cannot be null!");
            }
            this.item = item;
        }

        public abstract ItemStack generate(Object var1, Random var2);

        public boolean equals(Object obj) {
            return obj instanceof LootItem && ((LootItem)obj).item == this.item;
        }

        public int hashCode() {
            return Item.func_150891_b((Item)this.item);
        }
    }
}

