/*
 * Decompiled with CFR 0.152.
 */
package factorization.aabbdebug;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import factorization.api.Coord;
import factorization.shared.Core;
import factorization.util.SpaceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import org.lwjgl.opengl.GL11;

public enum AabbDebugger {
    INSTANCE;

    static final List<AxisAlignedBB> boxes;
    static final List<AxisAlignedBB> frozen;
    static final List<Line> lines;
    static final List<Line> frozen_lines;
    public static boolean freeze;

    private AabbDebugger() {
        Core.loadBus((Object)this);
        ClientCommandHandler.instance.func_71560_a(new ICommand(){

            public int compareTo(ICommand other) {
                return this.func_71517_b().compareTo(other.func_71517_b());
            }

            public int compareTo(Object obj) {
                return this.compareTo((ICommand)obj);
            }

            public String func_71517_b() {
                return "boxdbg";
            }

            public String func_71518_a(ICommandSender p_71518_1_) {
                return "/bxdbg freeze|thaw|clean";
            }

            public List func_71514_a() {
                return null;
            }

            public void func_71515_b(ICommandSender player, String[] args) {
                String arg0;
                String string = arg0 = args.length > 0 ? args[0] : "help";
                if (arg0.equals("freeze")) {
                    freeze = true;
                } else if (arg0.equals("thaw")) {
                    freeze = false;
                } else if (arg0.equals("clean")) {
                    frozen.clear();
                    frozen_lines.clear();
                } else {
                    player.func_145747_a((IChatComponent)new ChatComponentText(this.func_71518_a(player)));
                }
            }

            public boolean func_71519_b(ICommandSender p_71519_1_) {
                return true;
            }

            public List func_71516_a(ICommandSender p_71516_1_, String[] p_71516_2_) {
                return null;
            }

            public boolean func_82358_a(String[] p_82358_1_, int p_82358_2_) {
                return false;
            }
        });
    }

    static <T> List<T> list() {
        return Collections.synchronizedList(new ArrayList());
    }

    public static void addBox(AxisAlignedBB box) {
        if (box == null) {
            return;
        }
        boxes.add(box.func_72329_c());
    }

    public static void addBox(Coord c) {
        if (c == null) {
            return;
        }
        AabbDebugger.addBox(SpaceUtil.createAABB(c, c.add(1, 1, 1)));
    }

    public static void addLine(Vec3 start, Vec3 end) {
        Line line = new Line();
        line.start = SpaceUtil.copy(start);
        line.end = SpaceUtil.copy(end);
        lines.add(line);
    }

    @SubscribeEvent
    public void clearBox(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            if (!(!freeze || boxes.isEmpty() && lines.isEmpty())) {
                frozen.clear();
                frozen_lines.clear();
                frozen.addAll(boxes);
                frozen_lines.addAll(lines);
            }
            boxes.clear();
            lines.clear();
        }
    }

    boolean hasBoxes() {
        return !frozen.isEmpty() || !boxes.isEmpty() || !lines.isEmpty() || !frozen_lines.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void drawBoxes(RenderWorldLastEvent event) {
        if (!this.hasBoxes()) {
            return;
        }
        WorldClient w = Minecraft.func_71410_x().field_71441_e;
        if (w == null) {
            return;
        }
        EntityLivingBase eyePos = Minecraft.func_71410_x().field_71451_h;
        double cx = eyePos.field_70142_S + (eyePos.field_70165_t - eyePos.field_70142_S) * (double)event.partialTicks;
        double cy = eyePos.field_70137_T + (eyePos.field_70163_u - eyePos.field_70137_T) * (double)event.partialTicks;
        double cz = eyePos.field_70136_U + (eyePos.field_70161_v - eyePos.field_70136_U) * (double)event.partialTicks;
        GL11.glPushAttrib((int)24576);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-cx), (double)(-cy), (double)(-cz));
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2896);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        GL11.glDisable((int)3553);
        GL11.glLineWidth((float)4.0f);
        List<Object> list = boxes;
        synchronized (list) {
            for (AxisAlignedBB box : boxes) {
                RenderGlobal.func_147590_a((AxisAlignedBB)box, (int)0x800000);
            }
        }
        list = frozen;
        synchronized (list) {
            for (AxisAlignedBB box : frozen) {
                RenderGlobal.func_147590_a((AxisAlignedBB)box, (int)0x4040B0);
            }
        }
        GL11.glLineWidth((float)2.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        GL11.glBegin((int)1);
        list = lines;
        synchronized (list) {
            for (Line line : lines) {
                GL11.glVertex3d((double)line.start.field_72450_a, (double)line.start.field_72448_b, (double)line.start.field_72449_c);
                GL11.glVertex3d((double)line.end.field_72450_a, (double)line.end.field_72448_b, (double)line.end.field_72449_c);
                GL11.glVertex3d((double)line.start.field_72450_a, (double)line.start.field_72448_b, (double)line.start.field_72449_c);
                GL11.glVertex3d((double)line.start.field_72450_a, (double)(line.start.field_72448_b + 0.1), (double)line.start.field_72449_c);
            }
        }
        GL11.glEnd();
        GL11.glColor4f((float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBegin((int)1);
        list = frozen_lines;
        synchronized (list) {
            for (Line line : frozen_lines) {
                GL11.glVertex3d((double)line.start.field_72450_a, (double)line.start.field_72448_b, (double)line.start.field_72449_c);
                GL11.glVertex3d((double)line.end.field_72450_a, (double)line.end.field_72448_b, (double)line.end.field_72449_c);
                GL11.glVertex3d((double)line.start.field_72450_a, (double)line.start.field_72448_b, (double)line.start.field_72449_c);
                GL11.glVertex3d((double)line.start.field_72450_a, (double)(line.start.field_72448_b + 0.1), (double)line.start.field_72449_c);
            }
        }
        GL11.glEnd();
        GL11.glDepthMask((boolean)true);
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    static {
        boxes = AabbDebugger.list();
        frozen = AabbDebugger.list();
        lines = AabbDebugger.list();
        frozen_lines = AabbDebugger.list();
        freeze = false;
    }

    private static class Line {
        Vec3 start;
        Vec3 end;

        private Line() {
        }
    }
}

