/*
 * Decompiled with CFR 0.152.
 */
package factorization.api;

import factorization.api.HeatConverters;
import factorization.api.IFurnaceHeatable;
import net.minecraft.block.BlockFurnace;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.world.World;

class DefaultHeatConverter
implements HeatConverters.IHeatConverter {
    DefaultHeatConverter() {
    }

    @Override
    public IFurnaceHeatable convert(World w, int x, int y, int z) {
        TileEntity te = w.func_147438_o(x, y, z);
        if (te instanceof IFurnaceHeatable) {
            return (IFurnaceHeatable)te;
        }
        if (te instanceof TileEntityFurnace) {
            return new FurnaceHeating((TileEntityFurnace)te);
        }
        return null;
    }

    private static class FurnaceHeating
    implements IFurnaceHeatable {
        final TileEntityFurnace furnace;

        FurnaceHeating(TileEntityFurnace furnace) {
            this.furnace = furnace;
        }

        @Override
        public boolean acceptsHeat() {
            ItemStack inputItem = this.furnace.func_70301_a(0);
            if (inputItem == null) {
                return false;
            }
            ItemStack smeltOutput = FurnaceRecipes.func_77602_a().func_151395_a(inputItem);
            if (smeltOutput == null) {
                return false;
            }
            ItemStack outputSlot = this.furnace.func_70301_a(2);
            if (outputSlot == null) {
                return true;
            }
            if (!outputSlot.func_77969_a(smeltOutput)) {
                return false;
            }
            int result = outputSlot.field_77994_a + smeltOutput.field_77994_a;
            return result <= this.furnace.func_70297_j_() && result <= smeltOutput.func_77976_d();
        }

        @Override
        public void giveHeat() {
            boolean needStart = !this.isStarted();
            int topBurnTime = 200;
            if (this.furnace.field_145956_a < 200) {
                ++this.furnace.field_145956_a;
                if (needStart) {
                    BlockFurnace.func_149931_a((this.furnace.field_145956_a > 0 ? 1 : 0) != 0, (World)this.furnace.func_145831_w(), (int)this.furnace.field_145851_c, (int)this.furnace.field_145848_d, (int)this.furnace.field_145849_e);
                }
            } else {
                ++this.furnace.field_145961_j;
                this.furnace.field_145961_j = Math.min(this.furnace.field_145961_j, 199);
            }
        }

        @Override
        public boolean hasLaggyStart() {
            return true;
        }

        @Override
        public boolean isStarted() {
            return this.furnace.func_145950_i();
        }
    }
}

