/*
 * Decompiled with CFR 0.152.
 */
package factorization.api;

import factorization.api.Coord;
import factorization.util.ItemUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCarpet;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.BlockStainedGlassPane;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public enum FzColor {
    NO_COLOR(null, 0xFFFFFF),
    WHITE("dyeWhite", 0xF0F0F0),
    ORANGE("dyeOrange", 15435844),
    MAGENTA("dyeMagenta", 12801229),
    LIGHTBLUE("dyeLightBlue", 6719955),
    YELLOW("dyeYellow", 14602026),
    LIME("dyeLime", 4312372),
    PINK("dyePink", 14188952),
    GRAY("dyeGray", 0x434343),
    LIGHTGRAY("dyeLightGray", 0xABABAB),
    CYAN("dyeCyan", 2651799),
    PURPLE("dyePurple", 8073150),
    BLUE("dyeBlue", 2437522),
    BROWN("dyeBrown", 5320730),
    GREEN("dyeGreen", 3887386),
    RED("dyeRed", 11743532),
    BLACK("dyeBlack", 0x1E1B1B);

    public final String dyeName;
    public final int hex;
    private final List<ItemStack> ore_entries;
    private static FzColor[] cache;
    public static final FzColor[] VALID_COLORS;

    private FzColor(String dyeName, int hex) {
        this.dyeName = dyeName;
        this.hex = hex;
        this.ore_entries = dyeName == null ? new ArrayList<ItemStack>() : OreDictionary.getOres((String)dyeName);
    }

    public int getR() {
        return (this.hex & 0xFF0000) >> 16;
    }

    public int getG() {
        return (this.hex & 0xFF00) >> 8;
    }

    public int getB() {
        return this.hex & 0xFF;
    }

    public float getRed() {
        return (float)((this.hex & 0xFF0000) >> 16) / 255.0f;
    }

    public float getGreen() {
        return (float)((this.hex & 0xFF00) >> 8) / 255.0f;
    }

    public float getBlue() {
        return (float)(this.hex & 0xFF) / 255.0f;
    }

    public static FzColor readColor(Coord c) {
        if (c == null || c.w == null) {
            return NO_COLOR;
        }
        Block b = c.getBlock();
        if (b == null) {
            return NO_COLOR;
        }
        if (b instanceof BlockColored || b instanceof BlockStainedGlassPane || b instanceof BlockStainedGlass || b instanceof BlockCarpet) {
            int md = c.getMd();
            if (md < 0 || md >= 16) {
                return NO_COLOR;
            }
            return cache[md + 1];
        }
        return NO_COLOR;
    }

    private static FzColor[] getValidColors() {
        FzColor[] ret = new FzColor[cache.length - 1];
        int i = 0;
        for (FzColor color : cache) {
            if (color == NO_COLOR) continue;
            ret[i] = color;
            ++i;
        }
        return ret;
    }

    public boolean conflictsWith(FzColor other) {
        if (this == NO_COLOR || other == NO_COLOR) {
            return false;
        }
        return this != other;
    }

    public static FzColor fromOrdinal(byte id) {
        if (id < cache.length && id >= 0) {
            return cache[id];
        }
        return NO_COLOR;
    }

    public byte toOrdinal() {
        return (byte)this.ordinal();
    }

    public static FzColor fromVanillaColorIndex(int id) {
        return FzColor.fromOrdinal((byte)(1 + id));
    }

    public int toVanillaColorIndex() {
        if (this == NO_COLOR) {
            return 0;
        }
        return this.ordinal() - 1;
    }

    public static FzColor fromItem(ItemStack is) {
        if (is == null) {
            return NO_COLOR;
        }
        for (FzColor color : VALID_COLORS) {
            if (!ItemUtil.oreDictionarySimilarEfficient(color.ore_entries, is)) continue;
            return color;
        }
        return NO_COLOR;
    }

    static {
        cache = FzColor.values();
        VALID_COLORS = FzColor.getValidColors();
    }
}

