/*
 * Decompiled with CFR 0.152.
 */
package factorization.api.adapter;

import factorization.api.adapter.Adapter;
import factorization.api.adapter.InterfaceAdapter;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

class AdapterExample {
    AdapterExample() {
    }

    void init() {
        ISparkly.adapter.register(Block.class, new ISparkly(){

            @Override
            public int getSparklePower(World w, int x, int y, int z) {
                Block b = w.func_147439_a(x, y, z);
                if (b == Blocks.field_150484_ah) {
                    return 100;
                }
                if (b == Blocks.field_150402_ci) {
                    return -10;
                }
                return 0;
            }
        });
        final ISparkly sparkly_inventory = new ISparkly(){

            @Override
            public int getSparklePower(World w, int x, int y, int z) {
                TileEntity te = w.func_147438_o(x, y, z);
                if (te instanceof IInventory) {
                    IInventory inv = (IInventory)te;
                    ItemStack first = inv.func_70301_a(0);
                    if (first == null) {
                        return 0;
                    }
                    return first.func_77973_b() == Items.field_151156_bN ? 10000 : 0;
                }
                return 0;
            }
        };
        ISparkly.adapter.register(new Adapter<Block, ISparkly>(){

            @Override
            public ISparkly adapt(Block val) {
                return sparkly_inventory;
            }

            @Override
            public boolean canAdapt(Class<?> valClass) {
                return valClass.isAssignableFrom(ITileEntityProvider.class);
            }

            @Override
            public int priority() {
                return 0;
            }
        });
    }

    public static void printSparkliness(World w, int x, int y, int z) {
        ISparkly sparkly = ISparkly.adapter.cast(w.func_147439_a(x, y, z));
        int sparklePower = 0;
        if (sparkly != null) {
            sparklePower = sparkly.getSparklePower(w, x, y, z);
        }
        System.out.println("The sparkle power is " + sparklePower);
    }

    class BlockVampire
    extends Block
    implements ISparkly {
        public BlockVampire(Material shiny) {
            super(shiny);
        }

        @Override
        public int getSparklePower(World w, int x, int y, int z) {
            return Integer.MAX_VALUE;
        }
    }

    static interface ISparkly {
        public static final InterfaceAdapter<Block, ISparkly> adapter = InterfaceAdapter.get(ISparkly.class);

        public int getSparklePower(World var1, int var2, int var3, int var4);
    }
}

