/*
 * Decompiled with CFR 0.152.
 */
package factorization.api.adapter;

import factorization.api.adapter.Adapter;
import factorization.api.adapter.GenericAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class InterfaceAdapter<SOURCE, TARGET>
implements Comparator<Adapter>,
Adapter<SOURCE, TARGET> {
    public final Class<TARGET> targetInterface;
    private final HashMap<Class<? extends SOURCE>, Adapter<? extends SOURCE, TARGET>> adapterCache = new HashMap();
    private final ArrayList<Adapter<? extends SOURCE, TARGET>> adapters = new ArrayList();
    private Adapter<SOURCE, TARGET> null_adapter = this;
    private Adapter<? extends SOURCE, TARGET> fallbackAdapter = nullAdapter;
    private static final HashMap<Class, InterfaceAdapter> common_adapters = new HashMap();
    private static final Adapter<?, ?> nullAdapter = new GenericAdapter(null, null);

    public static <S, T> InterfaceAdapter<S, T> get(Class<T> targetInterface) {
        InterfaceAdapter<S, T> ret = common_adapters.get(targetInterface);
        if (ret == null) {
            ret = InterfaceAdapter.getExtra(targetInterface);
            common_adapters.put(targetInterface, ret);
        }
        if (ret.targetInterface != targetInterface) {
            throw new ClassCastException("targetInterfaces don't match");
        }
        return ret;
    }

    public static <S, T> InterfaceAdapter<S, T> getExtra(Class<T> targetInterface) {
        return new InterfaceAdapter(targetInterface);
    }

    public <OBJ extends SOURCE> void register(Class<OBJ> inClass, TARGET outInterface) {
        GenericAdapter<OBJ, TARGET> ret = new GenericAdapter<OBJ, TARGET>(inClass, outInterface);
        this.register(ret);
    }

    public <REGISTERED_SOURCE extends SOURCE> InterfaceAdapter<SOURCE, TARGET> register(Adapter<REGISTERED_SOURCE, TARGET> adapter) {
        this.adapters.add(adapter);
        this.adapterCache.clear();
        return this;
    }

    public void setFallbackAdapter(Adapter<? extends SOURCE, TARGET> fallbackAdapter) {
        this.adapterCache.clear();
        this.fallbackAdapter = fallbackAdapter;
    }

    public Adapter<? extends SOURCE, TARGET> getFallbackAdapter() {
        return this.fallbackAdapter;
    }

    public void setNullAdapter(Adapter<SOURCE, TARGET> nullAdapter) {
        this.adapterCache.clear();
        this.null_adapter = nullAdapter;
    }

    public Adapter<? extends SOURCE, TARGET> getNullAdapter() {
        return this.null_adapter;
    }

    public List<Adapter<? extends SOURCE, TARGET>> getAdapters() {
        this.adapterCache.clear();
        return this.adapters;
    }

    public <OBJ extends SOURCE> TARGET cast(OBJ obj) {
        if (obj == null) {
            return this.null_adapter.adapt(null);
        }
        Class<?> objClass = obj.getClass();
        Adapter<Object, TARGET> adapter = this.adapterCache.get(objClass);
        if (adapter == null) {
            adapter = this.findAdapter(objClass);
            this.adapterCache.put(objClass, adapter);
        }
        return adapter.adapt(obj);
    }

    private InterfaceAdapter(Class<TARGET> targetInterface) {
        this.targetInterface = targetInterface;
    }

    private <OBJ extends SOURCE> Adapter<OBJ, TARGET> findAdapter(Class<OBJ> objClass) {
        if (this.adapterCache.isEmpty()) {
            Collections.sort(this.adapters, this);
        }
        if (this.targetInterface.isAssignableFrom(objClass)) {
            return this;
        }
        for (Adapter<SOURCE, TARGET> a : this.adapters) {
            if (!a.canAdapt(objClass)) continue;
            return a;
        }
        return this.fallbackAdapter;
    }

    @Override
    @Deprecated
    public int compare(Adapter o1, Adapter o2) {
        int p1 = o1.priority();
        int p2 = o2.priority();
        return p1 - p2;
    }

    @Override
    @Deprecated
    public TARGET adapt(SOURCE val) {
        return (TARGET)val;
    }

    @Override
    @Deprecated
    public boolean canAdapt(Class<?> valClass) {
        return this.targetInterface.isAssignableFrom(valClass);
    }

    @Override
    @Deprecated
    public int priority() {
        return 0;
    }
}

