/*
 * Decompiled with CFR 0.152.
 */
package factorization.api.datahelpers;

import factorization.api.FzOrientation;
import factorization.api.datahelpers.DataIdentity;
import factorization.api.datahelpers.IDataSerializable;
import factorization.api.datahelpers.Share;
import factorization.api.datahelpers.UnionEnumeration;
import factorization.util.DataUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraftforge.fluids.FluidTank;

public abstract class DataHelper {
    protected String name;

    public DataHelper as(Share share, String set_name) {
        this.name = set_name;
        if (this.shouldStore(share)) {
            return this;
        }
        return DataIdentity.instance;
    }

    protected abstract boolean shouldStore(Share var1);

    public DataHelper asSameShare(String set_name) {
        this.name = set_name;
        return this;
    }

    public abstract boolean isReader();

    public final boolean isWriter() {
        return !this.isReader();
    }

    public boolean isNBT() {
        return false;
    }

    public NBTTagCompound getTag() {
        return null;
    }

    public boolean hasLegacy(String name) {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void log(String message) {
    }

    public <E extends IDataSerializable> E putIDS(E val) throws IOException {
        if (val == null) {
            throw new NullPointerException();
        }
        return (E)val.serialize(this.name, this);
    }

    public abstract boolean putBoolean(boolean var1) throws IOException;

    public abstract byte putByte(byte var1) throws IOException;

    public abstract short putShort(short var1) throws IOException;

    public abstract int putInt(int var1) throws IOException;

    public abstract long putLong(long var1) throws IOException;

    public abstract float putFloat(float var1) throws IOException;

    public abstract double putDouble(double var1) throws IOException;

    public abstract String putString(String var1) throws IOException;

    public abstract int[] putIntArray(int[] var1) throws IOException;

    public abstract NBTTagCompound putTag(NBTTagCompound var1) throws IOException;

    public abstract ItemStack[] putItemArray(ItemStack[] var1) throws IOException;

    public ArrayList<ItemStack> putItemList(ArrayList<ItemStack> value) throws IOException {
        if (this.isReader() && this.hasLegacy(this.name + "_len")) {
            return this.putItemArray_legacy(value);
        }
        return this.putItemList_efficient(value);
    }

    protected ArrayList<ItemStack> putItemList_efficient(ArrayList<ItemStack> value) throws IOException {
        return this.putItemArray_legacy(value);
    }

    @Deprecated
    private ArrayList<ItemStack> putItemArray_legacy(ArrayList<ItemStack> value) throws IOException {
        String prefix = this.name;
        int len = this.asSameShare(prefix + "_len").putInt(value.size());
        if (this.isReader()) {
            value.clear();
            value.ensureCapacity(len);
            for (int i = 0; i < len; ++i) {
                value.add(this.asSameShare(prefix + "_" + i).putItemStack(null));
            }
        } else {
            for (int i = 0; i < len; ++i) {
                this.asSameShare(prefix + "_" + i).putItemStack(value.get(i));
            }
        }
        return value;
    }

    public FzOrientation putFzOrientation(FzOrientation value) throws IOException {
        return this.putEnum(value);
    }

    public UUID putUUID(UUID uuid) throws IOException {
        String base_name = this.name;
        if (this.isReader()) {
            long msb = this.asSameShare(base_name + "MSB").putLong(0L);
            long lsb = this.asSameShare(base_name + "LSB").putLong(0L);
            return new UUID(msb, lsb);
        }
        this.asSameShare(base_name + "MSB").putLong(uuid.getMostSignificantBits());
        this.asSameShare(base_name + "LSB").putLong(uuid.getLeastSignificantBits());
        return uuid;
    }

    public ItemStack putItemStack(ItemStack value) throws IOException {
        if (this.isReader()) {
            NBTTagCompound tag = this.putTag(new NBTTagCompound());
            ItemStack ret = ItemStack.func_77949_a((NBTTagCompound)tag);
            if (ret != null && ret.func_77973_b() == null) {
                return null;
            }
            return ret;
        }
        ItemStack it = value == null ? DataUtil.NULL_ITEM : value;
        NBTTagCompound writtenTag = it.func_77955_b(new NBTTagCompound());
        this.putTag(writtenTag);
        return value;
    }

    public FluidTank putTank(FluidTank tank) throws IOException {
        if (this.isWriter()) {
            NBTTagCompound tag = new NBTTagCompound();
            tank.writeToNBT(tag);
            this.putTag(tag);
            return tank;
        }
        NBTTagCompound tag = this.putTag(new NBTTagCompound());
        tank.readFromNBT(tag);
        return tank;
    }

    public AxisAlignedBB putBox(AxisAlignedBB box) throws IOException {
        box.field_72340_a = this.asSameShare(this.name + ".minX").putDouble(box.field_72340_a);
        box.field_72336_d = this.asSameShare(this.name + ".maxX").putDouble(box.field_72336_d);
        box.field_72338_b = this.asSameShare(this.name + ".minY").putDouble(box.field_72338_b);
        box.field_72337_e = this.asSameShare(this.name + ".maxY").putDouble(box.field_72337_e);
        box.field_72339_c = this.asSameShare(this.name + ".minZ").putDouble(box.field_72339_c);
        box.field_72334_f = this.asSameShare(this.name + ".maxZ").putDouble(box.field_72334_f);
        return box;
    }

    public Vec3 putVec3(Vec3 val) throws IOException {
        String prefix = this.name;
        val.field_72450_a = this.asSameShare(prefix + ".x").putDouble(val.field_72450_a);
        val.field_72448_b = this.asSameShare(prefix + ".y").putDouble(val.field_72448_b);
        val.field_72449_c = this.asSameShare(prefix + ".z").putDouble(val.field_72449_c);
        this.name = prefix;
        return val;
    }

    public <E extends Enum> E putEnum(E value) throws IOException {
        int i = this.putInt(value.ordinal());
        if (this.isWriter()) {
            return value;
        }
        return (E)((Enum)value.getDeclaringClass().getEnumConstants()[i]);
    }

    public Object putUnion(UnionEnumeration classes, Object val) throws IOException {
        Class<?> k;
        String origName = this.name;
        String typeName = origName + ".type";
        if (this.isWriter()) {
            byte index = classes.getIndex(val);
            this.asSameShare(typeName).putByte(index);
            k = classes.classByIndex(index);
        } else {
            byte index = this.asSameShare(typeName).putByte((byte)-1);
            val = classes.byIndex(index);
            k = classes.classByIndex(index);
            if (val == null) {
                throw new IOException("Tried to load invalid type with index: " + index);
            }
        }
        this.asSameShare(origName);
        if (val instanceof IDataSerializable) {
            return this.putIDS((IDataSerializable)val);
        }
        if (k == Boolean.class) {
            return this.putBoolean((Boolean)val);
        }
        if (k == Byte.class) {
            return this.putByte((Byte)val);
        }
        if (k == Short.class) {
            return this.putShort((Short)val);
        }
        if (k == Integer.class) {
            return this.putInt((Integer)val);
        }
        if (k == Long.class) {
            return this.putLong((Long)val);
        }
        if (k == Float.class) {
            return Float.valueOf(this.putFloat(((Float)val).floatValue()));
        }
        if (k == Double.class) {
            return this.putDouble((Double)val);
        }
        if (k == String.class) {
            return this.putString((String)val);
        }
        if (k == FzOrientation.class) {
            return this.putFzOrientation((FzOrientation)((Object)val));
        }
        if (k == UUID.class) {
            return this.putUUID((UUID)val);
        }
        if (k == ItemStack.class) {
            return this.putItemStack((ItemStack)val);
        }
        if (k == int[].class) {
            return this.putIntArray((int[])val);
        }
        if (k == NBTTagCompound.class) {
            return this.putTag((NBTTagCompound)val);
        }
        if (k == FluidTank.class) {
            return this.putTank((FluidTank)val);
        }
        if (k == AxisAlignedBB.class) {
            return this.putBox((AxisAlignedBB)val);
        }
        if (k == Vec3.class) {
            return this.putVec3((Vec3)val);
        }
        if (val instanceof Enum) {
            return this.putEnum((Enum)val);
        }
        throw new IOException("Unhandled class: " + k);
    }
}

