/*
 * Decompiled with CFR 0.152.
 */
package factorization.api.datahelpers;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.Share;
import factorization.util.DataUtil;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class DataInByteBuf
extends DataHelper {
    private final ByteBuf dis;
    private final Side side;

    public DataInByteBuf(ByteBuf dis, Side side) {
        this.dis = dis;
        this.side = side;
    }

    @Override
    protected boolean shouldStore(Share share) {
        return share.is_public;
    }

    @Override
    public boolean isReader() {
        return true;
    }

    @Override
    public boolean putBoolean(boolean value) throws IOException {
        return this.dis.readBoolean();
    }

    @Override
    public byte putByte(byte value) throws IOException {
        return this.dis.readByte();
    }

    @Override
    public short putShort(short value) throws IOException {
        return this.dis.readShort();
    }

    @Override
    public int putInt(int value) throws IOException {
        return this.dis.readInt();
    }

    @Override
    public long putLong(long value) throws IOException {
        return this.dis.readLong();
    }

    @Override
    public float putFloat(float value) throws IOException {
        return this.dis.readFloat();
    }

    @Override
    public double putDouble(double value) throws IOException {
        return this.dis.readDouble();
    }

    @Override
    public String putString(String value) throws IOException {
        return ByteBufUtils.readUTF8String((ByteBuf)this.dis);
    }

    @Override
    public NBTTagCompound putTag(NBTTagCompound value) throws IOException {
        return ByteBufUtils.readTag((ByteBuf)this.dis);
    }

    @Override
    public ItemStack[] putItemArray(ItemStack[] value) throws IOException {
        for (int i = 0; i < value.length; ++i) {
            ItemStack is = ItemStack.func_77949_a((NBTTagCompound)ByteBufUtils.readTag((ByteBuf)this.dis));
            if (DataUtil.NULL_ITEM.func_77969_a(is)) {
                is = null;
            }
            value[i] = is;
        }
        return value;
    }

    @Override
    public int[] putIntArray(int[] value) throws IOException {
        int len = this.dis.readInt();
        if (value == null || len != value.length) {
            value = new int[len];
        }
        for (int i = 0; i < len; ++i) {
            value[i] = this.dis.readInt();
        }
        return value;
    }
}

