/*
 * Decompiled with CFR 0.152.
 */
package factorization.api.datahelpers;

import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.DataHelperNBT;
import factorization.api.datahelpers.Share;
import factorization.shared.Core;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class DataInNBT
extends DataHelperNBT {
    public DataInNBT(NBTTagCompound theTag) {
        this.tag = theTag;
    }

    @Override
    protected boolean shouldStore(Share share) {
        return !share.is_transient;
    }

    @Override
    public boolean isReader() {
        return true;
    }

    @Override
    public boolean hasLegacy(String name) {
        return this.tag.func_74764_b(name);
    }

    @Override
    public DataHelper as(Share share, String set_name) {
        return super.as(share, set_name);
    }

    @Override
    public DataHelper asSameShare(String set_name) {
        return super.asSameShare(set_name);
    }

    private void err() {
        Core.logWarning("Failed to load " + this.name + "; will use default value.", new Object[0]);
        Core.logWarning("The tag: " + this.tag, new Object[0]);
    }

    @Override
    public boolean putBoolean(boolean value) throws IOException {
        try {
            return this.tag.func_74767_n(this.name);
        }
        catch (Throwable t) {
            this.err();
            return value;
        }
    }

    @Override
    public byte putByte(byte value) throws IOException {
        try {
            return this.tag.func_74771_c(this.name);
        }
        catch (Throwable t) {
            this.err();
            return value;
        }
    }

    @Override
    public short putShort(short value) throws IOException {
        try {
            return this.tag.func_74765_d(this.name);
        }
        catch (Throwable t) {
            this.err();
            return value;
        }
    }

    @Override
    public int putInt(int value) throws IOException {
        try {
            return this.tag.func_74762_e(this.name);
        }
        catch (Throwable t) {
            this.err();
            return value;
        }
    }

    @Override
    public long putLong(long value) throws IOException {
        try {
            return this.tag.func_74763_f(this.name);
        }
        catch (Throwable t) {
            this.err();
            return value;
        }
    }

    @Override
    public float putFloat(float value) throws IOException {
        try {
            return this.tag.func_74760_g(this.name);
        }
        catch (Throwable t) {
            this.err();
            return value;
        }
    }

    @Override
    public double putDouble(double value) throws IOException {
        try {
            return this.tag.func_74769_h(this.name);
        }
        catch (Throwable t) {
            this.err();
            return value;
        }
    }

    @Override
    public String putString(String value) throws IOException {
        try {
            return this.tag.func_74779_i(this.name);
        }
        catch (Throwable t) {
            this.err();
            return value;
        }
    }

    @Override
    public NBTTagCompound putTag(NBTTagCompound value) throws IOException {
        try {
            return this.tag.func_74775_l(this.name);
        }
        catch (Throwable t) {
            this.err();
            return value;
        }
    }

    @Override
    protected ArrayList<ItemStack> putItemList_efficient(ArrayList<ItemStack> value) throws IOException {
        try {
            NBTTagList buffer = this.tag.func_150295_c(this.name, 10);
            int size = buffer.func_74745_c();
            value.clear();
            value.ensureCapacity(size);
            for (int i = 0; i < size; ++i) {
                NBTTagCompound it = buffer.func_150305_b(i);
                ItemStack is = ItemStack.func_77949_a((NBTTagCompound)it);
                value.add(is);
            }
            return value;
        }
        catch (Throwable t) {
            this.err();
            return value;
        }
    }

    @Override
    public ItemStack[] putItemArray(ItemStack[] value) throws IOException {
        try {
            NBTTagList buffer = this.tag.func_150295_c(this.name, 10);
            for (int i = 0; i < value.length; ++i) {
                NBTTagCompound tag = buffer.func_150305_b(i);
                value[i] = tag == null ? null : ItemStack.func_77949_a((NBTTagCompound)tag);
            }
            return value;
        }
        catch (Throwable t) {
            this.err();
            return value;
        }
    }

    @Override
    public int[] putIntArray(int[] value) throws IOException {
        try {
            return this.tag.func_74759_k(this.name);
        }
        catch (Throwable t) {
            this.err();
            return value;
        }
    }
}

