/*
 * Decompiled with CFR 0.152.
 */
package factorization.api.datahelpers;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.Share;
import factorization.util.DataUtil;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class DataOutByteBuf
extends DataHelper {
    private final ByteBuf dos;
    private final Side side;

    public DataOutByteBuf(ByteBuf dos, Side side) {
        this.dos = dos;
        this.side = side;
    }

    @Override
    protected boolean shouldStore(Share share) {
        return share.is_public;
    }

    @Override
    public boolean isReader() {
        return false;
    }

    @Override
    public boolean putBoolean(boolean value) throws IOException {
        this.dos.writeBoolean(value);
        return value;
    }

    @Override
    public byte putByte(byte value) throws IOException {
        this.dos.writeByte((int)value);
        return value;
    }

    @Override
    public short putShort(short value) throws IOException {
        this.dos.writeShort((int)value);
        return value;
    }

    @Override
    public int putInt(int value) throws IOException {
        this.dos.writeInt(value);
        return value;
    }

    @Override
    public long putLong(long value) throws IOException {
        this.dos.writeLong(value);
        return value;
    }

    @Override
    public float putFloat(float value) throws IOException {
        this.dos.writeFloat(value);
        return value;
    }

    @Override
    public double putDouble(double value) throws IOException {
        this.dos.writeDouble(value);
        return value;
    }

    @Override
    public String putString(String value) throws IOException {
        ByteBufUtils.writeUTF8String((ByteBuf)this.dos, (String)value);
        return value;
    }

    @Override
    public NBTTagCompound putTag(NBTTagCompound value) throws IOException {
        ByteBufUtils.writeTag((ByteBuf)this.dos, (NBTTagCompound)value);
        return value;
    }

    @Override
    public ItemStack[] putItemArray(ItemStack[] value) throws IOException {
        for (ItemStack is : value) {
            if (is == null) {
                is = DataUtil.NULL_ITEM;
            }
            ByteBufUtils.writeTag((ByteBuf)this.dos, (NBTTagCompound)is.func_77955_b(new NBTTagCompound()));
        }
        return value;
    }

    @Override
    public int[] putIntArray(int[] value) throws IOException {
        this.dos.writeInt(value.length);
        for (int v : value) {
            this.dos.writeInt(v);
        }
        return value;
    }
}

