/*
 * Decompiled with CFR 0.152.
 */
package factorization.api.datahelpers;

import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.DataHelperNBT;
import factorization.api.datahelpers.Share;
import factorization.util.DataUtil;
import factorization.util.ItemUtil;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class DataOutNBT
extends DataHelperNBT {
    public DataOutNBT(NBTTagCompound theTag) {
        this.tag = theTag;
    }

    public DataOutNBT() {
        this(new NBTTagCompound());
    }

    @Override
    public DataHelper as(Share share, String set_name) {
        DataHelper ret = super.as(share, set_name);
        if (ret == this && this.tag.func_74764_b(set_name)) {
            throw new IllegalStateException("Writing name twice!");
        }
        return ret;
    }

    @Override
    public DataHelper asSameShare(String set_name) {
        DataHelper ret = super.asSameShare(set_name);
        if (ret == this && this.tag.func_74764_b(set_name)) {
            throw new IllegalStateException("Writing name twice!");
        }
        return ret;
    }

    @Override
    public NBTTagCompound getTag() {
        return this.tag;
    }

    @Override
    public boolean putBoolean(boolean value) throws IOException {
        this.tag.func_74757_a(this.name, value);
        return value;
    }

    @Override
    public byte putByte(byte value) throws IOException {
        this.tag.func_74774_a(this.name, value);
        return value;
    }

    @Override
    public short putShort(short value) throws IOException {
        this.tag.func_74777_a(this.name, value);
        return value;
    }

    @Override
    public int putInt(int value) throws IOException {
        this.tag.func_74768_a(this.name, value);
        return value;
    }

    @Override
    public long putLong(long value) throws IOException {
        this.tag.func_74772_a(this.name, value);
        return value;
    }

    @Override
    public float putFloat(float value) throws IOException {
        this.tag.func_74776_a(this.name, value);
        return value;
    }

    @Override
    public double putDouble(double value) throws IOException {
        this.tag.func_74780_a(this.name, value);
        return value;
    }

    @Override
    public String putString(String value) throws IOException {
        this.tag.func_74778_a(this.name, value);
        return value;
    }

    @Override
    public NBTTagCompound putTag(NBTTagCompound value) throws IOException {
        this.tag.func_74782_a(this.name, (NBTBase)value);
        return value;
    }

    @Override
    protected boolean shouldStore(Share share) {
        return !share.is_transient;
    }

    @Override
    public boolean isReader() {
        return false;
    }

    @Override
    protected ArrayList<ItemStack> putItemList_efficient(ArrayList<ItemStack> value) throws IOException {
        if (value.isEmpty()) {
            return value;
        }
        NBTTagList buffer = new NBTTagList();
        for (ItemStack item : value) {
            if (ItemUtil.normalize(item) == null) continue;
            NBTTagCompound btag = new NBTTagCompound();
            item.func_77955_b(btag);
            buffer.func_74742_a((NBTBase)btag);
        }
        this.tag.func_74782_a(this.name, (NBTBase)buffer);
        return value;
    }

    @Override
    public ItemStack[] putItemArray(ItemStack[] value) throws IOException {
        NBTTagList buffer = new NBTTagList();
        for (ItemStack item : value) {
            if (item == null) {
                item = DataUtil.NULL_ITEM;
            }
            NBTTagCompound btag = new NBTTagCompound();
            item.func_77955_b(btag);
            buffer.func_74742_a((NBTBase)btag);
        }
        this.tag.func_74782_a(this.name, (NBTBase)buffer);
        return value;
    }

    @Override
    public int[] putIntArray(int[] value) throws IOException {
        this.tag.func_74783_a(this.name, value);
        return value;
    }
}

