/*
 * Decompiled with CFR 0.152.
 */
package factorization.api.datahelpers;

import factorization.api.datahelpers.MergedDataHelper;
import factorization.api.datahelpers.Share;
import java.io.IOException;
import java.util.Map;

public class DataValidator
extends MergedDataHelper {
    Map<String, Object> fields;
    boolean has_log = false;

    public DataValidator(Map<String, Object> fields) {
        this.fields = fields;
    }

    @Override
    protected boolean shouldStore(Share share) {
        return share.is_public && share.client_can_edit;
    }

    @Override
    protected <E> E putImplementation(E o) throws IOException {
        if (!this.fields.containsKey(this.name)) {
            this.log("Missing data");
            return o;
        }
        return (E)this.fields.get(this.name);
    }

    @Override
    public boolean isReader() {
        return true;
    }

    @Override
    public void log(String message) {
        super.log(message);
        this.has_log = true;
    }

    @Override
    public boolean isValid() {
        return !this.has_log;
    }
}

