/*
 * Decompiled with CFR 0.152.
 */
package factorization.api.datahelpers;

import factorization.api.datahelpers.DataValidator;
import factorization.api.datahelpers.Share;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class UnionEnumeration {
    public static final UnionEnumeration empty = new UnionEnumeration(new Class[0], new Object[0]);
    final Class<?>[] classes;
    final Object[] zeros;
    final Map<Class<?>, Integer> indexMap = new HashMap();

    private UnionEnumeration(Class<?>[] classes, Object[] zeros) {
        if (classes.length != zeros.length) {
            throw new IllegalArgumentException("Sizes do not match");
        }
        this.classes = classes;
        this.zeros = zeros;
        if (classes.length > 127) {
            throw new IllegalArgumentException("Too many types!");
        }
        for (int i = 0; i < classes.length; ++i) {
            this.indexMap.put(classes[i], i);
        }
        DataValidator data = new DataValidator(new HashMap<String, Object>());
        for (int i = 0; i < classes.length; ++i) {
            try {
                data.as(Share.VISIBLE_TRANSIENT, "#" + i).putUnion(this, zeros[i]);
                continue;
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public static UnionEnumeration build(Object ... parts) {
        if (parts.length % 2 != 0) {
            throw new IllegalArgumentException("Not pairs");
        }
        Class[] classes = new Class[parts.length / 2];
        Object[] zeros = new Object[parts.length / 2];
        for (int i = 0; i < parts.length; i += 2) {
            Class klass = (Class)parts[i];
            Object val = parts[i + 1];
            if (val != null && !klass.isInstance(val)) {
                throw new IllegalArgumentException("default value does not match class");
            }
            classes[i / 2] = klass;
            zeros[i / 2] = val;
            if (!(val == null ^ klass == Void.TYPE)) continue;
            throw new IllegalArgumentException("nulls must correspond to Voids.");
        }
        return new UnionEnumeration(classes, zeros);
    }

    public byte getIndex(Object val) {
        Integer integer;
        Class<?> k = val.getClass();
        while (true) {
            if (k == null) {
                throw new IllegalArgumentException("Type is not registered to be serialized: " + val + ", a " + val.getClass());
            }
            integer = this.indexMap.get(k);
            if (integer != null) break;
            k = k.getSuperclass();
        }
        return (byte)integer.intValue();
    }

    public Object byIndex(byte b) {
        return this.zeros[b];
    }

    public Class<?> classByIndex(byte index) {
        return this.classes[index];
    }
}

