/*
 * Decompiled with CFR 0.152.
 */
package factorization.artifact;

import factorization.artifact.ContainerForge;
import factorization.shared.Core;
import factorization.shared.NetworkFactorization;
import factorization.util.LangUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiArtifactForge
extends GuiContainer {
    ContainerForge container;
    GuiTextField name_field;
    GuiTextField lore_field;
    private static final ResourceLocation bgTexture = Core.getResource("textures/gui/artifactforge.png");

    public GuiArtifactForge(ContainerForge container) {
        super((Container)container);
        this.container = container;
        this.field_146999_f = 256;
        this.field_147000_g = 237;
    }

    GuiTextField makeField(int x, int y, int width, GuiTextField orig, int text_length) {
        String text = orig == null ? "" : orig.func_146179_b();
        int cornerX = (this.field_146294_l - this.field_146999_f) / 2;
        int cornerY = (this.field_146295_m - this.field_147000_g) / 2;
        GuiTextField ret = new GuiTextField(this.field_146289_q, cornerX + x, cornerY + y, width, 12);
        ret.func_146193_g(-1);
        ret.func_146204_h(-1);
        ret.func_146185_a(true);
        ret.func_146203_f(text_length);
        ret.func_146180_a(text);
        return ret;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        this.name_field = this.makeField(143, 28, 103, this.name_field, 40);
        this.lore_field = this.makeField(143, 56, 103, this.lore_field, 160);
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_73869_a(char c, int sym) {
        if (this.name_field.func_146201_a(c, sym) || this.lore_field.func_146201_a(c, sym)) {
            this.container.forge.func_70296_d();
            this.syncFields();
        } else {
            super.func_73869_a(c, sym);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.name_field.func_146192_a(mouseX, mouseY, mouseButton);
        this.lore_field.func_146192_a(mouseX, mouseY, mouseButton);
    }

    void syncFields() {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        Core.network.sendPlayerMessage((EntityPlayer)player, NetworkFactorization.MessageType.ArtifactForgeName, this.name_field.func_146179_b(), this.lore_field.func_146179_b());
    }

    public void func_146276_q_() {
        super.func_146276_q_();
        double r = 59.0;
        double dTheta = Math.PI * 2 / (double)this.container.enchantSlots.size();
        int i = 0;
        double speed = 0.6283185307179586;
        int cx = 60;
        int cy = 67;
        for (Slot slot : this.container.enchantSlots) {
            double theta = dTheta * (double)i++ + speed * (double)System.currentTimeMillis() / 1000.0;
            int x = (int)((double)cx + Math.cos(theta) * r);
            int y = (int)((double)cy + Math.sin(theta) * r);
            slot.field_75223_e = x;
            slot.field_75221_f = y;
        }
    }

    protected void func_146976_a(float partial, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(bgTexture);
        int halfWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int halfHeight = (this.field_146295_m - this.field_147000_g) / 2;
        int x0 = halfWidth - 4;
        int y0 = halfHeight - 19 + 16;
        this.func_73729_b(x0, y0, 0, 0, this.field_146999_f, this.field_147000_g);
        int i = 8;
        for (Slot slot : this.container.enchantSlots) {
            int dx = this.container.forge.warnings[i] == 1 ? 18 : 0;
            this.func_73729_b(x0 + slot.field_75223_e + 3, y0 + slot.field_75221_f + 2, dx, 238, 18, 18);
            ++i;
        }
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glPushMatrix();
        if (this.name_field != null) {
            this.name_field.func_146194_f();
        }
        if (this.lore_field != null) {
            this.lore_field.func_146194_f();
        }
        GL11.glPopMatrix();
    }

    protected void func_146979_b(int p_146979_1_, int p_146979_2_) {
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"factorization.forge.name", (Object[])new Object[0]), 156, 16, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"factorization.forge.lore", (Object[])new Object[0]), 156, 45, 0x404040);
        String err = this.container.forge.error_message;
        if (err == null) {
            err = "lorehint";
        }
        int dy = 10;
        int y = 65;
        int i = 1;
        do {
            String key;
            String msg;
            if ((msg = LangUtil.translateExact(key = "factorization.forge.err." + err + "." + i)) == null) {
                if (i > 1) break;
                msg = key;
            }
            this.field_146289_q.func_78276_b(msg, 138, y + dy * i, 0x404040);
        } while (i++ <= 10);
    }

    public void func_73863_a(int mouseX, int mouseY, float partial) {
        super.func_73863_a(mouseX, mouseY, partial);
    }
}

