/*
 * Decompiled with CFR 0.152.
 */
package factorization.artifact;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import factorization.api.Coord;
import factorization.shared.Core;
import factorization.shared.Sound;
import factorization.util.PlayerUtil;
import java.util.Calendar;
import java.util.Locale;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatisticsFile;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class InspirationManager {
    static InspirationManager instance;
    static final StatBase lastArtifact;
    static final StatBase beenNotified;
    static final boolean DEBUG;
    private static final int days_per_artifact;
    private static final int check_tick_rate;
    public static final ChatStyle aqua;
    int ticks = 0;

    public static void init() {
        instance = new InspirationManager();
        Core.loadBus(instance);
    }

    static void set(StatisticsFile statsFile, EntityPlayer player, StatBase field, int val) {
        if (statsFile == null) {
            return;
        }
        statsFile.func_150873_a(player, field, val);
    }

    static int get(StatisticsFile statsFile, EntityPlayer player, StatBase field) {
        if (statsFile == null) {
            return -1;
        }
        return statsFile.func_77444_a(field);
    }

    static int today() {
        Calendar cal = Calendar.getInstance();
        if (DEBUG) {
            return cal.get(6) * 60 * 60 * 365 + cal.get(10) * 60 * 60 + cal.get(12) * 60;
        }
        return cal.get(6) + cal.get(1) * 365;
    }

    static boolean canMakeArtifact(StatisticsFile statsFile, EntityPlayer player) {
        if (statsFile == null) {
            return false;
        }
        int lastArtifactDay = InspirationManager.get(statsFile, player, lastArtifact);
        return lastArtifactDay + days_per_artifact <= InspirationManager.today();
    }

    public void poke(EntityPlayer player, boolean isLogin) {
        int today;
        if (PlayerUtil.isPlayerCreative(player)) {
            return;
        }
        StatisticsFile statsFile = PlayerUtil.getStatsFile(player);
        if (!InspirationManager.canMakeArtifact(statsFile, player)) {
            return;
        }
        int lastNoticeSent = InspirationManager.get(statsFile, player, beenNotified);
        boolean update = false;
        if (lastNoticeSent <= 0) {
            player.func_145747_a(new ChatComponentTranslation("factorization.artifact.cancreate", new Object[0]).func_150255_a(aqua));
            update = true;
        }
        if (lastNoticeSent != (today = InspirationManager.today()) && isLogin) {
            player.func_145747_a(new ChatComponentTranslation("factorization.artifact.canstillcreate", new Object[0]).func_150255_a(aqua));
            update = true;
        }
        if (update) {
            InspirationManager.set(statsFile, player, beenNotified, today);
        }
    }

    public static void resetArtifactDelay(EntityPlayer player) {
        StatisticsFile statsFile = PlayerUtil.getStatsFile(player);
        InspirationManager.set(statsFile, player, lastArtifact, InspirationManager.today());
        InspirationManager.set(statsFile, player, beenNotified, 0);
    }

    @SubscribeEvent
    public void login(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        StatisticsFile statsFile = PlayerUtil.getStatsFile(player);
        if (statsFile == null) {
            return;
        }
        if (statsFile.func_77444_a(lastArtifact) <= 0) {
            InspirationManager.resetArtifactDelay(player);
        } else {
            this.poke(player, true);
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (this.ticks++ < check_tick_rate) {
            return;
        }
        this.ticks = 0;
        for (Object obj : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
            if (!(obj instanceof EntityPlayer)) continue;
            EntityPlayer player = (EntityPlayer)obj;
            this.poke(player, false);
        }
    }

    public static boolean canMakeArtifact(EntityPlayer player) {
        if (PlayerUtil.isPlayerCreative(player)) {
            return true;
        }
        StatisticsFile statsFile = PlayerUtil.getStatsFile(player);
        return InspirationManager.canMakeArtifact(statsFile, player);
    }

    public static void makeArtifact(EntityPlayer player, ItemStack artifact) {
        String name = player.func_70005_c_();
        String key = "factorization.artifact.announce";
        if (name.toLowerCase(Locale.ROOT).startsWith("urist")) {
            key = key + ".urist";
        }
        String artifactName = artifact.func_82833_r();
        String toolName = artifact.func_77977_a() + ".name";
        ChatComponentTranslation msg = new ChatComponentTranslation(key, new Object[]{name, artifactName, new ChatComponentTranslation(toolName, new Object[0])});
        msg = msg.func_150255_a(aqua);
        MinecraftServer.func_71276_C().func_71203_ab().func_148544_a((IChatComponent)msg, false);
        InspirationManager.resetArtifactDelay(player);
        for (Object obj : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
            if (!(obj instanceof EntityPlayer)) continue;
            EntityPlayer peep = (EntityPlayer)obj;
            Sound.artifactForged.playAt(new Coord((Entity)peep));
        }
    }

    static {
        lastArtifact = new StatBase("factorization.artifact.last", (IChatComponent)new ChatComponentTranslation("factorization.artifact.last.name", new Object[0])).func_75971_g();
        beenNotified = new StatBase("factorization.artifact.notified", (IChatComponent)new ChatComponentTranslation("factorization.artifact.notify.name", new Object[0])).func_75971_g();
        DEBUG = Core.dev_environ;
        days_per_artifact = DEBUG ? 1 : 30;
        check_tick_rate = DEBUG ? 20 : 18000;
        aqua = new ChatStyle().func_150238_a(EnumChatFormatting.AQUA);
    }
}

