/*
 * Decompiled with CFR 0.152.
 */
package factorization.artifact;

import factorization.artifact.InspirationManager;
import factorization.artifact.ItemPotency;
import factorization.artifact.TileEntityLegendarium;
import factorization.shared.Core;
import factorization.util.ItemUtil;
import factorization.util.NumUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerRepair;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StringUtils;
import net.minecraftforge.oredict.OreDictionary;

public class InventoryForge
implements IInventory {
    final EntityPlayer player;
    public String name;
    public String lore;
    final Container container;
    public String error_message = "notools";
    static final int SLOT_FIRST = 0;
    static final int SLOT_SECOND = 1;
    static final int SLOT_DYE_1 = 2;
    static final int SLOT_DYE_2 = 3;
    static final int SLOT_OUT = 4;
    static final int SLOT_POTENT_START = 5;
    static final int SLOT_POTENT_END = 8;
    static final int SLOT_ENCHANT_START = 8;
    static final int SLOT_ENCHANT_END = 16;
    static final int SIZE = 16;
    ItemStack[] inv = new ItemStack[16];
    public byte[] warnings = new byte[16];
    boolean isDirty = true;
    static String[] dyes = new String[]{"dyeBlack", "dyeRed", "dyeGreen", "dyeBrown", "dyeBlue", "dyePurple", "dyeCyan", "dyeLightGray", "dyeGray", "dyePink", "dyeLime", "dyeYellow", "dyeLightBlue", "dyeMagenta", "dyeOrange", "dyeWhite"};
    static ArrayList[] dyeList = new ArrayList[16];

    public InventoryForge(EntityPlayer player, Container container) {
        this.player = player;
        this.container = container;
    }

    public int func_70302_i_() {
        return 16;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inv[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack ret = this.inv[slot].func_77979_a(amount);
        this.inv[slot] = ItemUtil.normalize(this.inv[slot]);
        if (slot == 4 && amount > 0 && !this.player.field_70170_p.field_72995_K) {
            ItemStack got = new ArtifactBuilder(false).buildArtifact(this.player, this.name, this.lore);
            InspirationManager.makeArtifact(this.player, got);
            return got;
        }
        return ret;
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inv[slot] = stack;
        if (slot == 4 && !this.player.field_70170_p.field_72995_K) {
            new ArtifactBuilder(false).buildArtifact(this.player, this.name, this.lore);
        }
    }

    public String func_145825_b() {
        return "factorization.inventory.forge";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public void func_70296_d() {
        if (this.player.field_70170_p.field_72995_K) {
            return;
        }
        this.isDirty = true;
    }

    void rebuildArtifact() {
        ItemStack newArtifact;
        this.inv[4] = newArtifact = new ArtifactBuilder(true).buildArtifact(this.player, this.name, this.lore);
        this.isDirty = false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public static int getDyeIndex(ItemStack stack) {
        if (stack == null) {
            return -1;
        }
        for (int i = 0; i < dyeList.length; ++i) {
            ArrayList list = dyeList[i];
            for (ItemStack dye : list) {
                if (!ItemUtil.couldMerge(stack, dye)) continue;
                return i;
            }
        }
        return -1;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (!InspirationManager.canMakeArtifact(this.player)) {
            this.error_message = "goaway";
            this.container.func_75142_b();
            return false;
        }
        if (slot == 0 || slot == 1) {
            ItemStack a = this.inv[0];
            ItemStack b = this.inv[1];
            if (a != null && b != null) {
                return false;
            }
            ItemStack template = a != null ? a : b;
            return ItemUtil.couldMerge(template, stack);
        }
        if (slot == 2 || slot == 3) {
            return InventoryForge.getDyeIndex(stack) >= 0;
        }
        if (slot == 4) {
            return false;
        }
        if (slot >= 5 && slot < 8) {
            return stack.func_77973_b() == Core.registry.item_potency && stack.func_77960_j() == 0;
        }
        return slot >= 8 && slot < 16;
    }

    static {
        for (int i = 0; i < dyes.length; ++i) {
            InventoryForge.dyeList[i] = OreDictionary.getOres((String)dyes[i]);
        }
    }

    class ArtifactBuilder {
        final boolean simulate;

        ArtifactBuilder(boolean simulate) {
            this.simulate = simulate;
        }

        void consume(int slot) {
            InventoryForge.this.warnings[slot] = 0;
            if (this.simulate) {
                return;
            }
            InventoryForge.this.inv[slot] = ItemUtil.normalDecr(InventoryForge.this.inv[slot]);
        }

        String takeDye(int slot) {
            int index = InventoryForge.getDyeIndex(InventoryForge.this.inv[slot]);
            if (index < 0) {
                return "";
            }
            this.consume(slot);
            String color_map = "042l15978daebdcno";
            return "\u00a7" + color_map.charAt(index);
        }

        ItemStack err(String msg) {
            InventoryForge.this.error_message = msg;
            return null;
        }

        int cleanWork(ItemStack stack) {
            NBTTagCompound tag = stack.func_77978_p();
            if (tag == null) {
                return 0;
            }
            int i = stack.func_82838_A();
            stack.func_82841_c(0);
            return i;
        }

        boolean basicallyIdentical(ItemStack a, ItemStack b) {
            int bDmg;
            double high;
            double range;
            if (a.func_77973_b() != b.func_77973_b()) {
                return false;
            }
            int aDmg = a.func_77960_j();
            double low = (double)aDmg * (1.0 - (range = 0.05));
            if (!NumUtil.intersect(low, high = (double)aDmg * (1.0 + range), bDmg = b.func_77960_j(), bDmg)) {
                return false;
            }
            NBTTagCompound atag = this.stubTag(a);
            NBTTagCompound btag = this.stubTag(b);
            for (String ignorable : new String[]{"RepairCost", "Meta"}) {
                atag.func_82580_o(ignorable);
                btag.func_82580_o(ignorable);
            }
            return atag.equals((Object)btag);
        }

        private NBTTagCompound stubTag(ItemStack is) {
            NBTTagCompound tag = is.func_77978_p();
            if (tag == null) {
                return new NBTTagCompound();
            }
            return (NBTTagCompound)tag.func_74737_b();
        }

        ItemStack buildArtifact(EntityPlayer player, String name, String lore) {
            if (player.field_70170_p.field_72995_K) {
                return InventoryForge.this.inv[4];
            }
            for (int i = 0; i < InventoryForge.this.warnings.length; ++i) {
                InventoryForge.this.warnings[i] = (byte)(InventoryForge.this.inv[i] != null ? 1 : 0);
            }
            InventoryForge.this.error_message = null;
            ItemStack first = InventoryForge.this.inv[0];
            ItemStack second = InventoryForge.this.inv[1];
            if (first == null && second == null) {
                return this.err("notools");
            }
            if (first == null || second == null) {
                return this.err("pair");
            }
            if (!this.basicallyIdentical(first, second)) {
                return this.err("notsame");
            }
            if (!TileEntityLegendarium.isTool(first)) {
                return this.err("nottool");
            }
            ItemStack output = first.func_77946_l();
            this.consume(0);
            this.consume(1);
            boolean gave_unbreaking = false;
            Map enchants = EnchantmentHelper.func_82781_a((ItemStack)output);
            ArrayList enchantIds = new ArrayList(enchants.keySet());
            boolean any = false;
            Iterator iterator = enchantIds.iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                Enchantment ench = Enchantment.field_77331_b[id];
                if (ench.func_77325_b() == 1) continue;
                int enchMax = ench.func_77325_b();
                int extra = enchMax * 3 / 2;
                if (extra > 4) {
                    extra = 4;
                }
                int sneaky_max = enchMax + extra;
                int level = (Integer)enchants.get(id);
                if (level >= sneaky_max) continue;
                enchants.put(id, level + 1);
                gave_unbreaking |= id == Enchantment.field_77347_r.field_77352_x;
                any = true;
            }
            if (any) {
                EnchantmentHelper.func_82782_a((Map)enchants, (ItemStack)output);
            }
            for (int i = 5; i < 8; ++i) {
                if (!ItemUtil.is(InventoryForge.this.inv[i], Core.registry.item_potency)) {
                    return this.err("potency");
                }
                Core.registry.item_potency.func_77663_a(InventoryForge.this.inv[i], player.field_70170_p, (Entity)player, 0, false);
                if (!ItemPotency.validBottle(InventoryForge.this.inv[i], player)) {
                    return this.err("potency");
                }
                this.consume(i);
            }
            int enchants2 = 0;
            int repairCount = this.cleanWork(output);
            for (int i = 8; i < 16; ++i) {
                ItemStack ench = InventoryForge.this.inv[i];
                if (ench == null) continue;
                ContainerRepair anvil = new ContainerRepair(player.field_71071_by, player.field_70170_p, -1, -1, -1, player);
                anvil.func_75141_a(0, output.func_77946_l());
                anvil.func_75141_a(1, ench.func_77946_l());
                anvil.func_82848_d();
                ItemStack upgraded = anvil.func_75139_a(2).func_75211_c();
                if (upgraded == null) continue;
                this.cleanWork(upgraded);
                if (ItemUtil.couldMerge(output, upgraded)) continue;
                this.consume(i);
                output = upgraded;
                ++enchants2;
            }
            output.func_82841_c(repairCount + 1);
            if (enchants2 <= 0) {
                return this.err("nobooks");
            }
            if (!gave_unbreaking) {
                int unbreaking = EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)output) + 1;
                Map enchantMap = EnchantmentHelper.func_82781_a((ItemStack)output);
                enchantMap.put(Enchantment.field_77347_r.field_77352_x, unbreaking);
                EnchantmentHelper.func_82782_a((Map)enchantMap, (ItemStack)output);
            }
            if (StringUtils.func_151246_b((String)name)) {
                return this.err("noname");
            }
            output.func_151001_c(this.takeDye(2) + name);
            if (!StringUtils.func_151246_b((String)lore)) {
                ItemUtil.setLore(output, lore.split(Pattern.quote("|")));
            }
            this.err("lorehint");
            return output;
        }
    }
}

