/*
 * Decompiled with CFR 0.152.
 */
package factorization.artifact;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.shared.Core;
import factorization.shared.ItemFactorization;
import factorization.util.ItemUtil;
import factorization.util.LangUtil;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.AnvilUpdateEvent;

public class ItemBrokenArtifact
extends ItemFactorization {
    public ItemBrokenArtifact() {
        super("brokenArtifact", Core.TabType.ARTIFACT);
        this.func_77625_d(1);
        Core.loadBus((Object)this);
    }

    public static ItemStack build(ItemStack orig) {
        NBTTagCompound out = new NBTTagCompound();
        orig.func_77955_b(out);
        ItemStack ret = new ItemStack((Item)Core.registry.brokenTool);
        NBTTagCompound tag = ItemUtil.getTag(ret);
        tag.func_74782_a("broken", (NBTBase)out);
        ret.func_77964_b(Math.abs(out.hashCode()) % 1000);
        return ret;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
    }

    public static ItemStack get(ItemStack orig) {
        if (orig == null) {
            return null;
        }
        if (!(orig.func_77973_b() instanceof ItemBrokenArtifact)) {
            return null;
        }
        NBTTagCompound tag = orig.func_77978_p();
        if (tag == null) {
            return null;
        }
        return ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("broken"));
    }

    public String func_77653_i(ItemStack is) {
        ItemStack held = ItemBrokenArtifact.get(is);
        if (held == null) {
            return super.func_77657_g(is);
        }
        return LangUtil.translateWithCorrectableFormat("item.factorization:brokenArtifact.shards", held.func_82833_r());
    }

    public void func_150895_a(Item stack, CreativeTabs tab, List list) {
    }

    @Override
    protected void addExtraInformation(ItemStack is, EntityPlayer player, List list, boolean verbose) {
        ItemStack held = ItemBrokenArtifact.get(is);
        if (held == null) {
            return;
        }
        ItemStack fresh = new ItemStack(held.func_77973_b());
        ItemStack repair = new ItemStack(this.getRepairItem(fresh));
        String got = LangUtil.translateWithCorrectableFormat("item.factorization:brokenArtifact.repairhint", repair.func_82833_r());
        Collections.addAll(list, got.split("\\\\n"));
        List infos = held.func_82840_a(player, false);
        if (!infos.isEmpty()) {
            list.add("");
            list.addAll(infos);
        }
    }

    public Item getRepairItem(ItemStack held) {
        Item template = held.func_77973_b();
        if (template instanceof ItemTool) {
            return ((ItemTool)template).func_150913_i().func_150995_f();
        }
        return template;
    }

    @SubscribeEvent
    public void reforge(AnvilUpdateEvent event) {
        ItemStack right = event.right;
        ItemStack left = event.left;
        if (!ItemUtil.is(left, this)) {
            return;
        }
        ItemStack held = ItemBrokenArtifact.get(left);
        if (held == null) {
            return;
        }
        Item template = this.getRepairItem(held);
        if (!ItemUtil.is(right, template)) {
            return;
        }
        if (right.func_77960_j() != 0) {
            return;
        }
        held.func_77964_b(0);
        int oldCost = held.func_82838_A();
        if (oldCost > 0) {
            held.func_82841_c(oldCost / 2);
        }
        event.output = held.func_77946_l();
        event.cost = 30;
        event.materialCost = 1;
    }
}

