/*
 * Decompiled with CFR 0.152.
 */
package factorization.artifact;

import factorization.artifact.ItemBrokenArtifact;
import java.util.Random;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderBrokenArtifact
implements IItemRenderer {
    int W = 8;
    int S = 16 / this.W;
    int layerCount = 2;
    byte[][] shuffles = new byte[10][];

    public RenderBrokenArtifact() {
        for (int i = 0; i < this.shuffles.length; ++i) {
            this.shuffles[i] = this.makeShuffle(i);
        }
    }

    byte[] makeShuffle(int seed) {
        byte[] shuffle = new byte[this.W * this.W * 2 * this.layerCount];
        Random rand = new Random(seed);
        int index = 0;
        for (int layer = 0; layer < this.layerCount; ++layer) {
            int s;
            int n;
            int randCount;
            int start = index;
            for (int x = 0; x < this.W; x = (int)((byte)(x + 1))) {
                for (int y = 0; y < this.W; y = (int)((byte)(y + 1))) {
                    shuffle[index++] = x;
                    shuffle[index++] = y;
                }
            }
            int end = index - 2;
            int len = (end /= 2) - (start /= 2);
            if (layer == 0) {
                randCount = len / 2;
                for (n = 0; n < randCount; ++n) {
                    s = start + rand.nextInt(len);
                    shuffle[s * 2 + 0] = -1;
                    shuffle[s * 2 + 1] = -1;
                }
                continue;
            }
            randCount = len / 2;
            for (n = 0; n < randCount; ++n) {
                s = start + rand.nextInt(len);
                int d = start + rand.nextInt(len);
                byte swap0 = shuffle[d * 2 + 0];
                byte swap1 = shuffle[d * 2 + 1];
                shuffle[d * 2 + 0] = shuffle[s * 2 + 0];
                shuffle[d * 2 + 1] = shuffle[s * 2 + 1];
                shuffle[s * 2 + 0] = swap0;
                shuffle[s * 2 + 1] = swap1;
            }
        }
        return shuffle;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return item.func_77942_o();
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type == IItemRenderer.ItemRenderType.ENTITY;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        ItemStack orig = ItemBrokenArtifact.get(item);
        if (orig == null) {
            return;
        }
        Tessellator tess = Tessellator.field_78398_a;
        if (type == IItemRenderer.ItemRenderType.ENTITY) {
            GL11.glDisable((int)2884);
        } else if (type == IItemRenderer.ItemRenderType.EQUIPPED) {
            GL11.glPushMatrix();
            GL11.glScaled((double)-1.0, (double)-1.0, (double)-1.0);
            float posterForwardHack = 0.034375f;
            GL11.glTranslated((double)-1.0, (double)-1.0, (double)posterForwardHack);
        }
        IIcon icon = orig.func_77954_c();
        double d = type == IItemRenderer.ItemRenderType.INVENTORY ? 1.0 : 0.0625;
        tess.func_78382_b();
        int index = 0;
        int shuffleIndex = Math.abs(item.func_77960_j()) % this.shuffles.length;
        byte[] shuffle = this.shuffles[shuffleIndex];
        for (int loop = 0; loop < this.layerCount; ++loop) {
            for (int x = 0; x < this.W; ++x) {
                for (int y = 0; y < this.W; ++y) {
                    double iu0 = shuffle[index++] * this.S;
                    double iv0 = shuffle[index++] * this.S;
                    if (iu0 == -1.0) continue;
                    double iu1 = iu0 + (double)this.S;
                    double iv1 = iv0 + (double)this.S;
                    float u0 = icon.func_94214_a(iu0);
                    float v0 = icon.func_94207_b(iv0);
                    float u1 = icon.func_94214_a(iu1);
                    float v1 = icon.func_94207_b(iv1);
                    double x0 = x * this.S;
                    double x1 = x0 + (double)this.S;
                    double y0 = y * this.S;
                    double y1 = y0 + (double)this.S;
                    tess.func_78374_a(x0 *= d, y0 *= d, 0.0, (double)u0, (double)v0);
                    tess.func_78374_a(x0, y1 *= d, 0.0, (double)u0, (double)v1);
                    tess.func_78374_a(x1 *= d, y1, 0.0, (double)u1, (double)v1);
                    tess.func_78374_a(x1, y0, 0.0, (double)u1, (double)v0);
                }
            }
        }
        GL11.glPushAttrib((int)16384);
        GL11.glEnable((int)3008);
        tess.func_78381_a();
        GL11.glPopAttrib();
        if (type == IItemRenderer.ItemRenderType.ENTITY) {
            GL11.glEnable((int)2884);
        } else if (type == IItemRenderer.ItemRenderType.EQUIPPED) {
            GL11.glPopMatrix();
        }
    }
}

