/*
 * Decompiled with CFR 0.152.
 */
package factorization.artifact;

import com.google.common.base.Strings;
import factorization.api.Coord;
import factorization.api.ICoordFunction;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.Share;
import factorization.artifact.ItemBrokenArtifact;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.common.FzConfig;
import factorization.notify.Notice;
import factorization.notify.Style;
import factorization.shared.BlockClass;
import factorization.shared.Core;
import factorization.shared.Sound;
import factorization.shared.TileEntityCommon;
import factorization.util.FzUtil;
import factorization.util.ItemUtil;
import factorization.util.SpaceUtil;
import factorization.weird.poster.EntityPoster;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSign;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityLegendarium
extends TileEntityCommon {
    static final int MIN_SIZE = FzConfig.legendarium_queue_size;
    static final int POSTER_RANGE = 16;
    static final float MIN_DAMAGE = 0.1f;
    static final int DAMAGE_PAD = 24;
    static final int SIGN_RANGE = 1;
    private static final boolean DEBUG = Core.dev_environ;
    private static final int WAIT_TIME = DEBUG ? 4000 : FzConfig.legendarium_delay_hours * 60 * 60 * 1000;
    long last_insert_time = 0L;
    ArrayList<ItemStack> queue = new ArrayList();
    static final String legendariumCount = "legendariumCount";

    @Override
    public void putData(DataHelper data) throws IOException {
        this.last_insert_time = data.as(Share.PRIVATE, "lastInsertTime").putLong(this.last_insert_time);
        this.queue = data.as(Share.PRIVATE, "queue").putItemList(this.queue);
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Lamp;
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.LEGENDARIUM;
    }

    boolean isDroid(EntityPlayer player) {
        if (player instanceof FakePlayer) {
            new Notice(this, "factorization.legendarium.nodroidsallowed", new String[0]).sendToAll();
            return true;
        }
        return false;
    }

    static boolean isTool(ItemStack is) {
        if (is == null) {
            return false;
        }
        if (is.field_77994_a != 1) {
            return false;
        }
        if (is.func_77976_d() > 1) {
            return false;
        }
        if (!is.func_77973_b().isRepairable()) {
            return false;
        }
        if (is.func_77958_k() <= 1) {
            return false;
        }
        return !is.func_77981_g();
    }

    static String analyzeItem(ItemStack is) {
        float maxDamage;
        if (is == null) {
            return "noitem";
        }
        if (!TileEntityLegendarium.isTool(is)) {
            return "not_tool";
        }
        if (!is.func_82837_s()) {
            return "not_artifact";
        }
        if (!is.func_77948_v()) {
            return "not_artifact";
        }
        int actualDamage = is.func_77958_k() - is.func_77960_j();
        if ((float)actualDamage > (maxDamage = (float)is.func_77958_k() * 0.1f + 24.0f)) {
            return "not_broken";
        }
        return null;
    }

    void sound(String name) {
        Sound.legendariumInsert.playAt(this);
    }

    long getWaitTicks() {
        long now = System.currentTimeMillis();
        long to_wait = this.last_insert_time + (long)WAIT_TIME - now;
        return to_wait / 1000L * 20L;
    }

    boolean isOverfull() {
        return this.queue.size() > MIN_SIZE;
    }

    @Override
    public boolean activate(EntityPlayer player, ForgeDirection side) {
        if (this.field_145850_b.field_72995_K) {
            return true;
        }
        if (this.isDroid(player)) {
            return false;
        }
        ItemStack held = player.func_70694_bm();
        if (held == null) {
            if (this.isOverfull()) {
                ItemStack front = this.queue.get(0);
                new Notice(this, "factorization.legendarium.canremove", new String[0]).withStyle(Style.DRAWITEM).withItem(front).sendTo(player);
                return true;
            }
            long ticks = this.getWaitTicks();
            if (ticks > 0L) {
                new Notice(this, "factorization.legendarium.wait", FzUtil.unitTranslateTimeTicks(ticks, 2)).sendTo(player);
            } else {
                new Notice(this, "factorization.legendarium.caninsert", new String[0]).sendTo(player);
            }
            return true;
        }
        String analysis = TileEntityLegendarium.analyzeItem(held);
        if (analysis != null) {
            if (analysis.equals("not_broken") && Core.dev_environ && player.func_70051_ag()) {
                new Notice(this, "<breaking item>", new String[0]).sendTo(player);
                held.func_77964_b(held.func_77958_k() - 1);
                return true;
            }
            new Notice(this, "factorization.legendarium.item_analysis." + analysis, new String[0]).sendTo(player);
            return true;
        }
        long ticks = this.getWaitTicks();
        if (ticks > 0L) {
            new Notice(this, "factorization.legendarium.wait", FzUtil.unitTranslateTimeTicks(ticks, 2)).sendTo(player);
            return true;
        }
        this.last_insert_time = System.currentTimeMillis();
        this.queue.add(ItemBrokenArtifact.build(held));
        player.func_70062_b(0, null);
        this.func_70296_d();
        this.sound("insert");
        this.populatePosters();
        return true;
    }

    boolean canRemove() {
        return true;
    }

    @Override
    public void click(EntityPlayer player) {
        if (this.queue.isEmpty()) {
            return;
        }
        if (this.isDroid(player)) {
            return;
        }
        if (ItemUtil.is(player.func_70694_bm(), Core.registry.spawnPoster)) {
            if (this.cleanPosters() == 0) {
                this.populatePosters();
                new Notice(this, "factorization.legendarium.posters.populated", new String[0]).sendTo(player);
            } else {
                new Notice(this, "factorization.legendarium.posters.cleaned", new String[0]).sendTo(player);
            }
            return;
        }
        if (!this.isOverfull()) {
            new Notice(this, "factorization.legendarium.notfull", new String[0]).sendTo(player);
            return;
        }
        ItemStack artifact = this.queue.remove(0);
        ItemUtil.giveItem(player, new Coord(this), artifact, ForgeDirection.UNKNOWN);
        this.func_70296_d();
        this.populatePosters();
    }

    @Override
    public boolean canPlaceAgainst(EntityPlayer player, Coord c, int side) {
        if (c.w.field_72995_K) {
            return true;
        }
        LegendariumPopulation population = LegendariumPopulation.load();
        String free = population.isFree(c.w);
        if (!Strings.isNullOrEmpty((String)free)) {
            new Notice(c, "factorization.legendarium.occupied", free).sendTo(player);
            return false;
        }
        return true;
    }

    @Override
    public void onPlacedBy(EntityPlayer player, ItemStack is, int side, float hitX, float hitY, float hitZ) {
        super.onPlacedBy(player, is, side, hitX, hitY, hitZ);
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        LegendariumPopulation population = LegendariumPopulation.load();
        population.setOccupied(new Coord(this), player, true);
    }

    static ItemStack unwrap(ItemStack is) {
        ItemStack ret = ItemBrokenArtifact.get(is);
        if (ret == null) {
            return is;
        }
        return ret;
    }

    @Override
    protected boolean removedByPlayer(EntityPlayer player, boolean willHarvest) {
        return super.removedByPlayer(player, willHarvest);
    }

    @Override
    protected void onRemove() {
        super.onRemove();
        this.cleanPosters();
        Coord at = new Coord(this);
        for (ItemStack stack : this.queue) {
            at.spawnItem(TileEntityLegendarium.unwrap(stack));
        }
        this.queue.clear();
        LegendariumPopulation population = LegendariumPopulation.load();
        population.setOccupied(new Coord(this), null, false);
    }

    @Override
    public IIcon getIcon(ForgeDirection dir) {
        if (dir.offsetY == 0) {
            return BlockIcons.artifact$legendarium_side;
        }
        return BlockIcons.artifact$legendarium_top;
    }

    List<EntityPoster> getPosters() {
        Coord min = new Coord(this).add(-16, -16, -16);
        Coord max = new Coord(this).add(16, 16, 16);
        AxisAlignedBB box = SpaceUtil.createAABB(min, max);
        List ret = this.field_145850_b.func_72872_a(EntityPoster.class, box);
        Collections.sort(ret, new Comparator<EntityPoster>(){

            @Override
            public int compare(EntityPoster o1, EntityPoster o2) {
                double d2;
                double d1 = o1.func_70092_e(TileEntityLegendarium.this.field_145851_c, TileEntityLegendarium.this.field_145848_d, TileEntityLegendarium.this.field_145849_e);
                if (d1 > (d2 = o2.func_70092_e(TileEntityLegendarium.this.field_145851_c, TileEntityLegendarium.this.field_145848_d, TileEntityLegendarium.this.field_145849_e))) {
                    return 1;
                }
                if (d1 < d2) {
                    return -1;
                }
                return 0;
            }
        });
        return ret;
    }

    void iterateSign(EntityPoster poster, ICoordFunction function) {
        for (Coord n : new Coord(poster).getNeighborsAdjacent()) {
            function.handle(n);
        }
    }

    int populatePosters() {
        int ret = 0;
        this.cleanPosters();
        Iterator<ItemStack> it = this.queue.iterator();
        for (EntityPoster poster : this.getPosters()) {
            if (poster.getItem() != null) continue;
            if (!it.hasNext()) break;
            final ItemStack artifact = it.next().func_77946_l();
            poster.setItem(artifact);
            poster.setLocked(true);
            poster.syncData();
            ++ret;
            ICoordFunction setSign = new ICoordFunction(){
                boolean set = false;

                @Override
                public void handle(Coord here) {
                    if (this.set) {
                        return;
                    }
                    if (!(here.getBlock() instanceof BlockSign)) {
                        return;
                    }
                    TileEntitySign sign = here.getTE(TileEntitySign.class);
                    if (sign == null) {
                        return;
                    }
                    for (int i = 0; i < sign.field_145915_a.length; ++i) {
                        if ("".equals(sign.field_145915_a[i])) continue;
                        return;
                    }
                    ItemStack orig = ItemBrokenArtifact.get(artifact);
                    if (orig == null) {
                        return;
                    }
                    this.setSignText(sign, orig);
                    here.markBlockForUpdate();
                    this.set = true;
                }

                private void setSignText(TileEntitySign sign, ItemStack orig) {
                    String name = orig.func_82833_r();
                    int sign_max_len = 15;
                    if (name.length() < sign_max_len) {
                        sign.field_145915_a[1] = name;
                        return;
                    }
                    if ((name = name.replaceAll("(\u00a7.)", "")).length() < sign_max_len) {
                        sign.field_145915_a[1] = name;
                        return;
                    }
                    ArrayList<String> out = new ArrayList<String>();
                    String build = "";
                    int total = 0;
                    for (String word : name.split(" ")) {
                        int l = word.length();
                        if (l + total + 1 < sign_max_len || total == 0) {
                            build = build + " " + word;
                            total += l + 1;
                            continue;
                        }
                        out.add(build);
                        build = word;
                        total = l;
                        if (out.size() > 4) break;
                    }
                    int start = 0;
                    if (out.size() <= 2) {
                        start = 1;
                    }
                    int end = Math.min(sign.field_145915_a.length, out.size());
                    for (int i = start; i < end; ++i) {
                        sign.field_145915_a[i] = (String)out.get(i);
                    }
                }
            };
            this.iterateSign(poster, setSign);
        }
        return ret;
    }

    int cleanPosters() {
        int ret = 0;
        for (EntityPoster poster : this.getPosters()) {
            if (!poster.isLocked() || !ItemUtil.is(poster.getItem(), Core.registry.brokenTool)) continue;
            poster.setItem(null);
            poster.setLocked(false);
            poster.syncData();
            ++ret;
            ICoordFunction clearSign = new ICoordFunction(){

                @Override
                public void handle(Coord here) {
                    if (!(here.getBlock() instanceof BlockSign)) {
                        return;
                    }
                    TileEntitySign sign = here.getTE(TileEntitySign.class);
                    if (sign == null) {
                        return;
                    }
                    for (int i = 0; i < sign.field_145915_a.length; ++i) {
                        sign.field_145915_a[i] = "";
                    }
                    here.markBlockForUpdate();
                }
            };
            this.iterateSign(poster, clearSign);
        }
        return ret;
    }

    @Override
    public boolean power() {
        return this.getWaitTicks() <= 0L;
    }

    @Override
    public void blockUpdateTick(Block myself) {
        super.blockUpdateTick(myself);
        this.scheduleTick();
    }

    void scheduleTick() {
        this.field_145850_b.func_147464_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, new Coord(this).getBlock(), (int)this.getWaitTicks());
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.scheduleTick();
        new Coord((TileEntity)this).w.func_147459_d(new Coord((TileEntity)this).x, new Coord((TileEntity)this).y, new Coord((TileEntity)this).z, new Coord(this).getBlock());
    }

    public static class LegendariumPopulation
    extends WorldSavedData {
        NBTTagCompound data = new NBTTagCompound();

        public LegendariumPopulation(String name) {
            super(name);
        }

        public void func_76184_a(NBTTagCompound tag) {
            this.data = tag;
        }

        public void func_76187_b(NBTTagCompound tag) {
            for (String key : this.data.func_150296_c()) {
                tag.func_74768_a(key, this.data.func_74762_e(key));
            }
        }

        private static String getName(World world) {
            IChunkProvider chunkGenerator = world.field_73011_w.func_76555_c();
            return chunkGenerator.getClass().getName();
        }

        String isFree(World world) {
            String name = LegendariumPopulation.getName(world);
            return this.data.func_74779_i(LegendariumPopulation.getName(world));
        }

        void setOccupied(Coord src, EntityPlayer user, boolean v) {
            String who = "someone";
            if (user != null) {
                who = user.func_70005_c_();
            }
            String worldName = LegendariumPopulation.getName(src.w);
            if (v) {
                this.data.func_74778_a(worldName, src.toShortString());
                Core.logInfo(who + " placed the hall of legends from " + src + "; worldName=" + worldName, new Object[0]);
            } else if (this.data.func_74764_b(worldName)) {
                this.data.func_82580_o(worldName);
                Core.logInfo(who + " removed the hall of legends from " + src + "; worldName=" + worldName, new Object[0]);
            }
            this.save();
        }

        static LegendariumPopulation load() {
            WorldServer w = MinecraftServer.func_71276_C().func_71218_a(0);
            LegendariumPopulation ret = (LegendariumPopulation)w.func_72943_a(LegendariumPopulation.class, TileEntityLegendarium.legendariumCount);
            if (ret == null) {
                ret = new LegendariumPopulation(TileEntityLegendarium.legendariumCount);
            }
            return ret;
        }

        public void save() {
            WorldServer w = MinecraftServer.func_71276_C().func_71218_a(0);
            w.func_72823_a(TileEntityLegendarium.legendariumCount, (WorldSavedData)this);
            this.func_76186_a(true);
            w.perWorldStorage.func_75744_a();
        }
    }
}

