/*
 * Decompiled with CFR 0.152.
 */
package factorization.beauty;

import factorization.algos.FastBag;
import factorization.api.Coord;
import factorization.api.ICoordFunction;
import factorization.shared.Core;
import factorization.util.DataUtil;
import factorization.util.ItemUtil;
import factorization.util.PlayerUtil;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraftforge.common.util.ForgeDirection;

public class EntityLeafBomb
extends EntityThrowable {
    ItemStack stack;
    ItemStack origStack;
    EntityPlayer shooter = null;
    int dim;
    double[] noise;
    Coord start;
    Coord end;
    String particle = "blockcrack_19_0";

    public EntityLeafBomb(World world) {
        super(world);
    }

    public EntityLeafBomb(World world, EntityLivingBase thrower, ItemStack stack) {
        super(world, thrower);
        this.origStack = stack;
    }

    public EntityLeafBomb(World world, double motionX, double motionY, double motionZ) {
        super(world, motionX, motionY, motionZ);
    }

    public void func_70109_d(NBTTagCompound tag) {
        super.func_70109_d(tag);
        if (this.origStack != null) {
            tag.func_74782_a("leafType", (NBTBase)DataUtil.item2tag(this.origStack));
        }
    }

    public void func_70020_e(NBTTagCompound tag) {
        super.func_70020_e(tag);
        this.origStack = DataUtil.tag2item(tag.func_74775_l("leafType"), null);
    }

    protected void func_70184_a(MovingObjectPosition mop) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.origStack == null) {
            return;
        }
        this.stack = Core.registry.leafBomb.getLeaves(this.origStack);
        Coord center = Coord.fromMop(this.field_70170_p, mop);
        if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            center.adjust(ForgeDirection.getOrientation((int)mop.field_72310_e));
        }
        this.shooter = PlayerUtil.makePlayer(center, "LeafBomb");
        int id = DataUtil.getId(this.stack);
        if (id == 0) {
            id = DataUtil.getId((Block)Blocks.field_150362_t);
        }
        this.particle = "blockcrack_" + id + "_" + this.stack.func_77960_j();
        boolean firstSpotSet = this.set(center);
        this.stack.field_77994_a += this.field_70146_Z.nextInt(2);
        int fortune = 1 + EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)this.origStack);
        this.stack.field_77994_a = (int)((double)this.stack.field_77994_a * Math.pow(3.0, fortune));
        if (firstSpotSet) {
            this.spawnGentleLeafBlob(center);
        } else {
            this.spamLeavesStupidly(center);
        }
        PlayerUtil.recycleFakePlayer(this.shooter);
        this.func_70106_y();
    }

    private void spamLeavesStupidly(Coord center) {
        boolean firstSpotSet = false;
        double r = 1.0;
        double desparation = 0.25;
        int limit = 128;
        while (this.stack.field_77994_a > 0 && limit-- > 0) {
            int dx = (int)(this.field_70146_Z.nextGaussian() * r);
            int dy = (int)(this.field_70146_Z.nextGaussian() * r);
            int dz = (int)(this.field_70146_Z.nextGaussian() * r);
            Coord hit = center.add(dx, dy, dz);
            if (!firstSpotSet) {
                firstSpotSet = this.set(hit);
                if (firstSpotSet) continue;
                r += desparation;
                continue;
            }
            boolean foundAdj = false;
            if (!this.isAdj(hit)) {
                r += desparation;
                continue;
            }
            this.set(hit);
        }
    }

    private void initNoise(Coord at) {
        this.dim = 32;
        int half = this.dim / 2;
        this.start = at.add(-half, -half, -half);
        this.end = at.add(half, half, half);
        int octaves = 3;
        if ((octaves = (int)((double)octaves - Math.log10(this.stack.field_77994_a / 5))) < 1) {
            octaves = 1;
        }
        this.noise = new NoiseGeneratorOctaves(this.field_70146_Z, octaves).func_76304_a(null, this.start.x, this.start.y, this.start.z, this.dim, this.dim, this.dim, (double)this.end.x, (double)this.end.y, (double)this.end.z);
    }

    double sample(Coord at) {
        if (!at.inside(this.start, this.end)) {
            return 0.0;
        }
        int index = at.x - this.start.x + (at.y - this.start.y) * this.dim + (at.z - this.start.z) * this.dim * this.dim;
        if (index < 0 || index >= this.noise.length) {
            return 0.0;
        }
        return this.noise[index] + 1.0;
    }

    private void spawnGentleLeafBlob(Coord at) {
        this.initNoise(at);
        final HashSet<Coord> visited = new HashSet<Coord>(this.stack.field_77994_a);
        FastBag<Coord> frontier = new FastBag<Coord>();
        frontier.add(at);
        visited.add(at);
        Coord min = at.copy();
        Coord max = at.copy();
        while (this.stack.field_77994_a > 0 && !frontier.isEmpty()) {
            Coord highest = null;
            double best = -1.0;
            for (Coord c : frontier) {
                double s = this.sample(c) / (double)at.distanceSq(c);
                if (!(s > best)) continue;
                best = s;
                highest = c;
            }
            if (highest == null) break;
            this.set(highest);
            frontier.remove(highest);
            for (Coord n : highest.getNeighborsAdjacent()) {
                if (!visited.add(n) || !n.isReplacable()) continue;
                frontier.add(n);
            }
            Coord.sort(min, at);
            Coord.sort(at, max);
        }
        Coord.iterateCube(min, max, new ICoordFunction(){

            @Override
            public void handle(Coord here) {
                if (!here.isReplacable()) {
                    return;
                }
                int accounted = 0;
                for (Coord n : here.getNeighborsAdjacent()) {
                    if (visited.contains(n)) {
                        ++accounted;
                        continue;
                    }
                    if (n.isNormalCube()) {
                        ++accounted;
                        continue;
                    }
                    if (n.getBlock().func_149688_o() == Material.field_151584_j) {
                        ++accounted;
                        continue;
                    }
                    return;
                }
                if (accounted == 6) {
                    ++EntityLeafBomb.this.stack.field_77994_a;
                    EntityLeafBomb.this.set(here);
                }
            }
        });
    }

    boolean isAdj(Coord at) {
        Block shouldBe = DataUtil.getBlock(this.stack);
        if (shouldBe != null) {
            for (Coord n : at.getNeighborsAdjacent()) {
                if (n.getBlock() != shouldBe) continue;
                return true;
            }
        } else {
            for (Coord n : at.getNeighborsAdjacent()) {
                if (n.getBlock().func_149688_o() != Material.field_151584_j) continue;
                return true;
            }
        }
        return false;
    }

    boolean set(Coord at) {
        if (ItemUtil.normalize(this.stack) == null) {
            return false;
        }
        if (!at.isReplacable()) {
            return false;
        }
        if (this.stack.func_77943_a(this.shooter, at.w, at.x, at.y, at.z, 0, 0.0f, 0.0f, 0.0f)) {
            --this.stack.field_77994_a;
        }
        ((WorldServer)this.field_70170_p).func_147487_a(this.particle, (double)at.x + 0.5, (double)at.y + 0.5, (double)at.z + 0.5, 4, 0.0, 0.0, 0.0, 1.0);
        return true;
    }
}

